//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    MatrixFunctions/mdsEig.h            \n
 * Section: libMath                             \n
 * Date:    2006/10/12                          \n
 *
 * $Id: mdsEig.h 331 2007-04-17 14:43:06Z spanel $
 *
 * Description:
 * - Computes eigenvalues and eigenvectors of a square symmetric matrix.
 */

#ifndef MDS_MATRIXFUNCTIONS_EIG_H
#define MDS_MATRIXFUNCTIONS_EIG_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsAssert.h>
#include <MDSTk/Base/mdsStaticAssert.h>
#include <MDSTk/Base/mdsTemplates.h>

#include "../mdsBase.h"
#include "../mdsMatrixBase.h"
#include "../mdsLapack.h"
#include "../mdsVector.h"

#include <cmath>


namespace mds
{
namespace math
{

//==============================================================================
/*
 * Global functions.
 */

//! Inplace computation of eigenvalues and eigenvectors of a square
//! symmetric matrix.
//! - Throws warning on failure.
template <class M, class V>
inline void eig(CMatrixBase<M>& Matrix, CVectorBase<V>& Values);


//==============================================================================
/*
 * Functions templates.
 */

// Include file containing methods templates
#include "mdsEig.hxx"


} // namespace math
} // namespace mds

#endif // MDS_MATRIXFUNCTIONS_EIG_H

