//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    MatrixFunctions/mdsDeterminant.h    \n
 * Section: libMath                             \n
 * Date:    2006/02/16                          \n
 *
 * $Id: mdsDeterminant.h 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Computes determinant of a square matrix.
 */

#ifndef MDS_MATRIXFUNCTIONS_DETERMINANT_H
#define MDS_MATRIXFUNCTIONS_DETERMINANT_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsAssert.h>

#include "../mdsBase.h"
#include "../mdsMatrixBase.h"
#include "../mdsLapack.h"
#include "../mdsVector.h"

#include <cmath>


namespace mds
{
namespace math
{

//==============================================================================
/*
 * Global functions.
 */

//! Returns determinant of a square matrix.
template <typename R, class M>
inline R getDeterminant(const CMatrixBase<M>& Matrix);


//==============================================================================
/*
 * Functions templates.
 */

// Include file containing methods templates
#include "mdsDeterminant.hxx"


} // namespace math
} // namespace mds

#endif // MDS_MATRIXFUNCTIONS_DETERMINANT_H

