//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2007 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsJPEGBaseFunctions.h              \n
 * Section: libImageIO                          \n
 * Date:    2007/06/12                          \n
 *
 * $Id:$
 *
 * Description:
 * - Reading and writing of JPEG images using libjpeg.
 */

#ifndef MDS_JPEGBASEFUNCTIONS_H
#define MDS_JPEGBASEFUNCTIONS_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Image/mdsImage.h>
#include <MDSTk/Module/mdsChannel.h>


namespace mds
{
namespace img
{

//==============================================================================
/*
 * Global functions.
 */

//! Reads grayscale JPEG image from a given input channel.
//! - Returns false on failure.
bool loadGrayJPEG(CImage8& Image, mds::mod::CChannel& Channel);

//! Reads full color JPEG image from a given input channel.
//! - Returns false on failure.
bool loadColorJPEG(CRGBImage& Image, mds::mod::CChannel& Channel);

//! Writes grayscale JPEG image to a given output channel.
//! - Quality of JPEG image is value in the range <0..255>.
//! - Returns false on failure.
bool saveGrayJPEG(const CImage8& Image, mds::mod::CChannel& Channel, int iQuality = 128);

//! Writes full color JPEG image to a given output channel.
//! - Quality of JPEG image is value in the range <0..255>.
//! - Returns false on failure.
bool saveColorJPEG(const CRGBImage& Image, mds::mod::CChannel& Channel, int iQuality = 128);


} // namespace img
} // namespace mds

#endif // MDS_JPEGBASEFUNCTIONS_H

