//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeFunctions.h                \n
 * Section: libImage                            \n
 * Date:    2006/02/20                          \n
 *
 * $Id: mdsVolumeFunctions.h 330 2007-04-17 14:30:54Z spanel $
 *
 * Description:
 * - Basic volume functions and operations.
 */

#ifndef MDS_VOLUMEFUNCTIONS_H
#define MDS_VOLUMEFUNCTIONS_H

#include <MDSTk/Base/mdsSetup.h>


//==============================================================================
/*
 * Include all predefined volume functions.
 */

// General volume functions
#include "VolumeFunctions/mdsGeneral.h"

// Special volume funtions
#include "VolumeFunctions/mdsConvolution.h"

// Volume histogram funtions
#include "VolumeFunctions/mdsHistogram.h"


#endif // MDS_VOLUMEFUNCTIONS_H

