//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeFilters.h                  \n
 * Section: libVolume                           \n
 * Date:    2005/09/06                          \n
 *
 * $Id: mdsVolumeFilters.h 442 2007-08-10 15:22:27Z spanel $
 * 
 * Description:
 * - Predefined volume filters.
 */

#ifndef MDS_VOLUMEFILTERS_H
#define MDS_VOLUMEFILTERS_H

#include <MDSTk/Base/mdsSetup.h>


//==============================================================================
/*
 * Include all predefined volume filters.
 */

// General volume filters
#include "VolumeFilters/mdsConvolution.h"
#include "VolumeFilters/mdsMedian.h"
#include "VolumeFilters/mdsMinMax.h"
#include "VolumeFilters/mdsMisc.h"

// Common volume filters.
#include "VolumeFilters/mdsGaussian.h"

// Common volume filters of concrete size
#include "VolumeFilters/mdsLaplacian.h"
#include "VolumeFilters/mdsPrewit.h"
#include "VolumeFilters/mdsSobel.h"
#include "VolumeFilters/mdsAveraging.h"

// Anisotropic filtering
#include "VolumeFilters/mdsAnisotropic.h"


#endif // MDS_VOLUMEFILTERS_H

