//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeEdgeDetector.h             \n
 * Section: libImage                            \n
 * Date:    2006/04/24                          \n
 *
 * $Id: mdsVolumeEdgeDetector.h 51 2006-08-08 13:33:56Z spanel $
 * 
 * Description:
 * - More sophisticated functions for volume edge detection.
 */

#ifndef MDS_VOLUMEEDGEDETECTOR_H
#define MDS_VOLUMEEDGEDETECTOR_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsIdentifier.h>

#include "mdsImageTypes.h"
#include "mdsVolume.h"


namespace mds
{
namespace img
{

//==============================================================================
/*!
 * Base class for all volume edge detectors.
 * - Parameter V is volume type.
 */
template <typename V>
struct CVolumeEdgeDetectorBase
{
    //! Check that V is a volume. You will see name of this enum somewhere
    //! in compiler error message if the type V is not volume.
    enum { TEMPLATE_PARAMETER_IS_NOT_VOLUME = V::CLASS_VOLUME };

    //! Volume type.
    typedef typename V::tVolume tVolume;

    //! Voxel type.
    typedef typename V::tVoxel tVoxel;

    //! Volume filter response type.
    typedef typename CPixelTraits<tVoxel>::tFilterResponse tResult;

    //! Voxels iterator.
    typedef typename V::tIterator tVolumeIterator;
};


//==============================================================================
/*!
 * Basic template providing volume edge detection functions. This template
 * is further specialized for concrete types.
 * - Parameter V is a volume type.
 * - 'Id' is a detector type.
 */
template <typename V, typename Id>
class CVolumeEdgeDetector : public CVolumeEdgeDetectorBase<V>
{
public:
    //! Volume edge detector base.
    typedef CVolumeEdgeDetectorBase<V> base;
    typedef typename base::tVolume tVolume;
    typedef typename base::tVoxel tVoxel;
    typedef typename base::tResult tResult;
    typedef typename base::tVolumeIterator tVolumeIterator;

public:
    //! Edge detection in a given volume.
    //! - Returns false on failure.
    bool operator()(const V& SrcVolume, V& DstVolume);
};


} // namespace img
} // namespace mds

#endif // MDS_VOLUMEEDGEDETECTOR_H

