//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2007 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeCornerDetector.h           \n
 * Section: libImage                            \n
 * Date:    2007/07/03                          \n
 *
 * $Id:$
 *
 * Description:
 * - More sophisticated functions for 3D corner/landmark detection.
 */

#ifndef MDS_VOLUMECORNERDETECTOR_H
#define MDS_VOLUMECORNERDETECTOR_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsIdentifier.h>

#include "mdsImageTypes.h"
#include "mdsVolume.h"
#include "mdsPoint.h"

// STL
#include <vector>


namespace mds
{
namespace img
{

//==============================================================================
/*!
 * Base class for all 3D corner/landmark detectors.
 * - Parameter V is a volume type.
 */
template <class V>
struct CVolumeCornerDetectorBase
{
    //! Check that V is volume. You will see name of this enum somewhere
    //! in compiler error message if the type V is not volume.
    enum { TEMPLATE_PARAMETER_IS_NOT_VOLUME = V::CLASS_VOLUME };

    //! Volume type.
    typedef typename V::tVolume tVolume;

    //! Voxel type.
    typedef typename V::tVoxel tVoxel;

    //! Volume filter response type.
    typedef typename CPixelTraits<tVoxel>::tFilterResponse tResult;

    //! Voxels iterator.
    typedef typename V::tIterator tVolumeIterator;

    //! Vector of found corners.
    typedef typename std::vector<CPoint3D> tCorners;
};


//==============================================================================
/*!
 * Basic template providing 3D corner/landmark detection functions.
 * This template is further specialized for concrete types.
 * - Parameter V is a volume type.
 * - 'Id' is a detector type.
 */
template <class V, typename Id>
class CVolumeCornerDetector : public CVolumeCornerDetectorBase<V>
{
public:
    //! Volume corner detector base.
    typedef CVolumeCornerDetectorBase<V> base;
    typedef typename base::tVolume tVolume;
    typedef typename base::tVoxel tVoxel;
    typedef typename base::tResult tResult;
    typedef typename base::tVolumeIterator tVolumeIterator;
    typedef typename base::tCorners tCorners;

public:
    //! Detects 3D corners in a given volume.
    //! - Returns false on failure. 
    bool operator()(const V& SrcVolume, tCorners& Corners);
};


} // namespace img
} // namespace mds

#endif // MDS_VOLUMECORNERDETECTOR_H 

