//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeBase.h                     \n
 * Section: libImage                            \n
 * Date:    2006/02/12                          \n
 *
 * $Id: mdsVolumeBase.h 375 2007-06-19 14:42:03Z spanel $
 *
 * Description:
 * - Base class for all volumes.
 */

#ifndef MDS_VOLUMEBASE_H
#define MDS_VOLUMEBASE_H

#include <MDSTk/Base/mdsSetup.h>


namespace mds
{
namespace img
{

//==============================================================================
/*!
 * Base class for all volumes.
 * - Base class takes a template parameter V. This parameter is the type
 *   of the class which derives from it (so called curiously recurring template
 *   pattern).
 */
template <class V>
class CVolumeBase
{
public:
    //! Volume type.
    typedef V tVolume;

public:
    //! Returns reference to the volume data implementation.
    tVolume& getImpl()
    {
        return *static_cast<tVolume *>(this);
    }
    const tVolume& getImpl() const
    {
        return *static_cast<const tVolume *>(this);
    }

protected:
    //! Default constructor.
    CVolumeBase() {}

    //! Copy constructor.
    CVolumeBase(const CVolumeBase&) {}

    //! Assignment operator.
    CVolumeBase& operator =(const CVolumeBase&) {}
};


} // namespace img
} // namespace mds

#endif // MDS_VOLUMEBASE_H

