//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsImageHistogram.h                 \n
 * Section: libImage                            \n
 * Date:    2005/02/10                          \n
 *
 * $Id: mdsImageHistogram.h 329 2007-04-17 12:03:51Z spanel $
 * 
 * Description:
 * - Image histogram computation and equalization
 */

#ifndef MDS_IMAGEHISTOGRAM_H
#define MDS_IMAGEHISTOGRAM_H

#include <MDSTk/Base/mdsSetup.h>

#include "mdsHistogram.h"
#include "mdsImage.h"


namespace mds
{
namespace img
{

//==============================================================================
/*
 * Basic template instances and type definitions.
 */

//! Histogram of the grayscale image, 8-bits per pixel
typedef CFullHistogram<CImage8>         CImage8Histogram;

//! Histogram of the grayscale image, 16-bits per pixel
typedef CFullHistogram<CImage16>        CImage16Histogram;

//! Histogram of the density image
typedef CFullHistogram<CDImage>         CDImageHistogram;

//! Histogram of the float image
typedef CQuantizedHistogram<CFImage>    CFImageHistogram;


} // namespace img
} // namespace mds

#endif // MDS_IMAGEHISTOGRAM_H

