//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsImageFilters.h                   \n
 * Section: libImage                            \n
 * Date:    2005/09/06                          \n
 *
 * $Id: mdsImageFilters.h 332 2007-04-20 12:21:49Z spanel $
 * 
 * Description:
 * - Predefined image filters.
 */

#ifndef MDS_IMAGEFILTERS_H
#define MDS_IMAGEFILTERS_H

#include <MDSTk/Base/mdsSetup.h>


//==============================================================================
/*
 * Include all predefined image filters.
 */

// General image filters.
#include "ImageFilters/mdsConvolution.h"
#include "ImageFilters/mdsMedian.h"
#include "ImageFilters/mdsMinMax.h"

// Common image filters.
#include "ImageFilters/mdsGaussian.h"
#include "ImageFilters/mdsLoG.h"
#include "ImageFilters/mdsDoG.h"

// Common image filters of concrete size.
#include "ImageFilters/mdsLaplacian.h"
#include "ImageFilters/mdsPrewit.h"
#include "ImageFilters/mdsSobel.h"
#include "ImageFilters/mdsRoberts.h"
#include "ImageFilters/mdsAveraging.h"

// Local moments
#include "ImageFilters/mdsLocalMoments.h"

// Anisotropic filtering
#include "ImageFilters/mdsAnisotropic.h"


#endif // MDS_IMAGEFILTERS_H

