//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsImageEdgeDetector.h              \n
 * Section: libImage                            \n
 * Date:    2005/09/20                          \n
 *
 * $Id: mdsImageEdgeDetector.h 90 2006-09-13 12:22:57Z spanel $
 * 
 * Description:
 * - More sophisticated functions for image edge detection.
 */

#ifndef MDS_IMAGEEDGEDETECTOR_H
#define MDS_IMAGEEDGEDETECTOR_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsIdentifier.h>

#include "mdsImageTypes.h"
#include "mdsImage.h"


namespace mds
{
namespace img
{

//==============================================================================
/*!
 * Base class for all image edge detectors.
 * - Parameter I is an image type.
 */
template <class I>
struct CImageEdgeDetectorBase
{
    //! Check that I is an image. You will see name of this enum somewhere
    //! in compiler error message if the type I is not image.
    enum { TEMPLATE_PARAMETER_IS_NOT_IMAGE = I::CLASS_IMAGE };

    //! Image type.
    typedef typename I::tImage tImage;

    //! Image pixel type.
    typedef typename I::tPixel tPixel;

    //! Image filter response type.
    typedef typename CPixelTraits<tPixel>::tFilterResponse tResult;

    //! Image pixels iterator.
    typedef typename I::tIterator tImageIterator;
};


//==============================================================================
/*!
 * Basic template providing image edge detection functions. This template
 * is further specialized for concrete types.
 * - Parameter I is an image type.
 * - 'Id' is a detector type.
 */
template <class I, typename Id>
class CImageEdgeDetector : public CImageEdgeDetectorBase<I>
{
public:
    //! Image edge detector base.
    typedef CImageEdgeDetectorBase<I> base;
    typedef typename base::tImage tImage;
    typedef typename base::tPixel tPixel;
    typedef typename base::tResult tResult;
    typedef typename base::tImageIterator tImageIterator;

public:
    //! Edge detection in a given image.
    //! - Returns false on failure.
    bool operator()(const I& SrcImage, I& DstImage);
};


} // namespace img
} // namespace mds

#endif // MDS_IMAGEEDGEDETECTOR_H

