//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)       \n
 * Copyright (c) 2003-2007 by PGMed@FIT            \n
 *
 * Author:  Petr Hyna, xhynap00@stud.fit.vutbr.cz  \n
 * File:    mdsImageCornerDetector.h               \n
 * Section: libImage                               \n
 * Date:    2007/04/12                             \n
 *
 * $Id:$
 * 
 * Description:
 * - More sophisticated functions for image corner detection.
 */

#ifndef MDS_IMAGECORNERDETECTOR_H
#define MDS_IMAGECORNERDETECTOR_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsIdentifier.h>

#include "mdsImageTypes.h"
#include "mdsImage.h"


namespace mds
{
namespace img
{

//==============================================================================
/*!
 * Base class for all image corner detectors.
 * - Parameter I is an image type.
 */
template <class I>
struct CImageCornerDetectorBase
{
    //! Check that I is an image. You will see name of this enum somewhere
    //! in compiler error message if the type I is not image.
    enum { TEMPLATE_PARAMETER_IS_NOT_IMAGE = I::CLASS_IMAGE };

    //! Image type.
    typedef typename I::tImage tImage;

    //! Image pixel type.
    typedef typename I::tPixel tPixel;

    //! Image filter response type.
    typedef typename CPixelTraits<tPixel>::tFilterResponse tResult;

    //! Image pixels iterator.
    typedef typename I::tIterator tImageIterator;
};


//==============================================================================
/*!
 * Basic template providing image corner detection functions. This template
 * is further specialized for concrete types.
 * - Parameter I is an image type.
 * - 'Id' is a detector type.
 */
template <class I, typename Id>
class CImageCornerDetector : public CImageCornerDetectorBase<I>
{
public:
    //! Image corner detector base.
    typedef CImageCornerDetectorBase<I> base;
    typedef typename base::tImage tImage;
    typedef typename base::tPixel tPixel;
    typedef typename base::tResult tResult;
    typedef typename base::tImageIterator tImageIterator;

public:
    //! Corner detection in a given image.
    //! - Returns false on failure. 
    bool operator()(const I& SrcImage, I& DstImage);
};


} // namespace img
} // namespace mds

#endif // MDS_IMAGECORNERDETECTOR_H 

