//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsImageBase.h                      \n
 * Section: libImage                            \n
 * Date:    2006/02/12                          \n
 *
 * $Id: mdsImageBase.h 375 2007-06-19 14:42:03Z spanel $
 *
 * Description:
 * - Base class for all images.
 */

#ifndef MDS_IMAGEBASE_H
#define MDS_IMAGEBASE_H

#include <MDSTk/Base/mdsSetup.h>


namespace mds
{
namespace img
{

//==============================================================================
/*!
 * Base class for all images.
 * - Base class takes a template parameter I. This parameter is the type
 *   of the class which derives from it (so called curiously recurring template
 *   pattern).
 */
template <class I>
class CImageBase
{
public:
    //! Image type.
    typedef I tImage;

public:
    //! Returns reference to the image implementation.
    tImage& getImpl()
    {
        return *static_cast<tImage *>(this);
    }
    const tImage& getImpl() const
    {
        return *static_cast<const tImage *>(this);
    }

protected:
    //! Default constructor.
    CImageBase() {}

    //! Copy constructor.
    CImageBase(const CImageBase&) {}

    //! Assignment operator.
    CImageBase& operator =(const CImageBase&) {}
};


} // namespace img
} // namespace mds

#endif // MDS_IMAGEBASE_H

