//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2007 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsHistogramBase.h                  \n
 * Section: libImage                            \n
 * Date:    2007/04/16                          \n
 *
 * $Id: mdsHistogramBase.h 375 2007-06-19 14:42:03Z spanel $
 *
 * Description:
 * - Base class for any histogram class.
 */

#ifndef MDS_HISTOGRAMBASE_H
#define MDS_HISTOGRAMBASE_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Math/mdsVector.h>


namespace mds
{
namespace img
{

//==============================================================================
/*!
 * Base class for all histogram classes.
 * - Base class takes a template parameter H. This parameter is the type
 *   of the class which derives from it (so called curiously recurring template
 *   pattern).
 */
template <class H>
class CHistogramBase
{
public:
    //! Concrete histogram type.
    typedef H tHistogram;

public:
    //! Returns reference to the histogram implementation.
    tHistogram& getImpl()
    {
        return *static_cast<tHistogram *>(this);
    }
    const tHistogram& getImpl() const
    {
        return *static_cast<const tHistogram *>(this);
    }

protected:
    //! Default constructor.
    CHistogramBase() {}

    //! Copy constructor.
    CHistogramBase(const CHistogramBase&) {}

    //! Assignment operator.
    CHistogramBase& operator =(const CHistogramBase&) {}
};


} // namespace img
} // namespace mds

#endif // MDS_HISTOGRAMBASE_H
