//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2007 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    VolumeFunctions/mdsHistogram.hxx    \n
 * Section: libImage                            \n
 * Date:    2007/04/17                          \n
 *
 * $Id: mdsHistogram.hxx 331 2007-04-17 14:43:06Z spanel $
 *
 * Description:
 * - Volume histogram functions.
 */


//==============================================================================
/*
 * Functions templates.
 */

template <class V>
inline bool histogramEqualization(CVolumeBase<V>& Volume)
{
    typedef typename V::tVoxel tVoxel;
    V& VolumeImpl = Volume.getImpl();

    // Useful constants
    static const tSize NumOfBins = 256;
    static const tVoxel VoxelMin = CPixelTraits<tVoxel>::getPixelMin();
    static const tVoxel VoxelMax = CPixelTraits<tVoxel>::getPixelMax();

    // Histogram of the image
    typedef CQuantizedHistogram<V> tHistogram;
    tHistogram Histogram(NumOfBins, VoxelMin, VoxelMax);
    if( !Histogram(VolumeImpl) )
    {
        return false;
    }

    // Compute the cumulative histogram
    Histogram.cumulate();

    // Get the number of samples
    typename tHistogram::tBin Max = Histogram.getCount(Histogram.getSize() - 1);
    if( Max <= 0 )
    {
        return false;
    }

    // Histogram equalization
    double dNorm = double(VoxelMax - VoxelMin) / double(Max);
    for( tSize k = 0; k < VolumeImpl.getZSize(); ++k )
    {
        for( tSize j = 0; j < VolumeImpl.getYSize(); ++j )
        {
            for( tSize i = 0; i < VolumeImpl.getXSize(); ++i )
            {
                tSize Index = Histogram.getIndex(VolumeImpl(i,j,k));
                VolumeImpl(i,j,k) = tVoxel(dNorm * Histogram.getCount(Index) + VoxelMin);
            }
        }
    }

    // O.K.
    return true;
}

