//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2007 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    VolumeFunctions/mdsHistogram.h      \n
 * Section: libImage                            \n
 * Date:    2007/04/17                          \n
 *
 * $Id: mdsHistogram.h 331 2007-04-17 14:43:06Z spanel $
 *
 * Description:
 * - Volume histogram functions.
 */

#ifndef MDS_VOLUMEFUNCTIONS_HISTOGRAM_H
#define MDS_VOLUMEFUNCTIONS_HISTOGRAM_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsAssert.h>
#include <MDSTk/Math/mdsBase.h>

#include "../mdsVolumeBase.h"
#include "../mdsVolumeHistogram.h"

// STL
#include <cmath>


namespace mds
{
namespace img
{

//==============================================================================
/*
 * Global functions.
 */

//! Histogram equalization.
template <class V>
inline bool histogramEqualization(CVolumeBase<V>& Volume);


//==============================================================================
/*
 * Functions templates.
 */

// Include the file containing functions templates.
#include "mdsHistogram.hxx"


} // namespace img
} // namespace mds

#endif // MDS_VOLUMEFUNCTIONS_HISTOGRAM_H

