//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    VolumeFilters/mdsAveraging.h        \n
 * Section: libVolume                           \n
 * Date:    2005/09/15                          \n
 *
 * $Id: mdsAveraging.hxx 50 2006-08-08 13:05:53Z spanel $
 * 
 * Description:
 * - Averaging volume filters.
 */


//==============================================================================
/*
 * Methods templates.
 */

//! Volume filter kernel
template <class V, template <typename> class N>
const CKernel3D::tData CVolumeFilter<V, VF_AVG_3, N>::KERNEL[] =
{
    1.0f,  1.0f,  1.0f,
    1.0f,  2.0f,  1.0f,
    1.0f,  1.0f,  1.0f,

    1.0f,  2.0f,  1.0f,
    2.0f,  4.0f,  2.0f,
    1.0f,  2.0f,  1.0f,

    1.0f,  1.0f,  1.0f,
    1.0f,  2.0f,  1.0f,
    1.0f,  1.0f,  1.0f
};


// Volume filtering method
template <class V, template <typename> class N>
bool CVolumeFilter<V, VF_AVG_3, N>::operator()(const V& SrcVolume, V& DstVolume)
{
    // Volume size
    tSize XCount = mds::math::getMin(SrcVolume.getXSize(), DstVolume.getXSize());
    tSize YCount = mds::math::getMin(SrcVolume.getYSize(), DstVolume.getYSize());
    tSize ZCount = mds::math::getMin(SrcVolume.getZSize(), DstVolume.getZSize());

    // Filter the image
    for( tSize z = 0; z < ZCount; ++z )
    {
        for( tSize y = 0; y < YCount; ++y )
        {
            for( tSize x = 0; x < XCount; ++x )
            {
                tResult Value = getResponse(SrcVolume, x, y, z);
                DstVolume.set(x, y, z, norm::normalize(Value));
            }
        }
    }

    // O.K.
    return true;
}


// Volume filter response
template <class V, template <typename> class N>
typename CVolumeFilter<V, VF_AVG_3, N>::tResult CVolumeFilter<V, VF_AVG_3, N>::getResponse(const V& SrcVolume, tSize x, tSize y, tSize z)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Filter kernel
    static const CKernel3D Kernel(KERNEL, getSize());

    // Compute filter response
    return Denom * convolve<tResult>(SrcVolume, x, y, z, Kernel);
}

