//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    VolumeFilters/mdsAveraging.h        \n
 * Section: libImage                            \n
 * Date:    2005/09/20                          \n
 *
 * $Id: mdsAveraging.h 50 2006-08-08 13:05:53Z spanel $
 * 
 * Description:
 * - Averaging volume filters.
 */

#ifndef MDS_VF_AVERAGING_H
#define MDS_VF_AVERAGING_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsAssert.h>
#include <MDSTk/Math/mdsBase.h>

#include "../mdsVolumeFilter.h"
#include "../mdsVolumeFunctions.h"
#include "../mdsKernel.h"


namespace mds
{
namespace img
{

//==============================================================================
/*
 * Identifiers declarations.
 */

//! Averaging volume filters
MDS_DECLARE_ID(VF_AVG_3);


//==============================================================================
/*!
 * Averaging image filter (3x3 version).
 * - Parameter V is a used image type.
 * - Kernel definition: \n
 *     [ 1  1  1 ]   \n
 *     [ 1  2  1 ]   \n
 *     [ 1  1  1 ]   \n
 *    1 [ 1  2  1 ]  \n
 *   -- [ 2  4  2 ]  \n
 *   36 [ 1  2  1 ]  \n
 *       [ 1  1  1 ] \n
 *       [ 1  2  1 ] \n
 *       [ 1  1  1 ] \n
 */
template <class V, template <typename> class N>
class CVolumeFilter<V, VF_AVG_3, N> : public CVolumeFilterBase<V,N>
{
public:
    //! Volume filter base.
    typedef CVolumeFilterBase<V,N> base;
    typedef typename base::norm norm;
    typedef typename base::tVolume tVolume;
    typedef typename base::tVoxel tVoxel;
    typedef typename base::tResult tResult;

    //! Number used to divide filter response
    static const int DENOM = 36;

    //! Filter kernel
    static const CKernel3D::tData KERNEL[];

public:
    //! Default constructor.
    CVolumeFilter() {}

    //! Destructor.
    ~CVolumeFilter() {}

    //! Filtering of input/source volume. Point filter responses are written
    //! to the destination volume.
    //! - Returns false on failure
    bool operator()(const V& SrcVolume, V& DstVolume);

    //! Returns filter response at specified volume position.
    //! - Value is not normalized!
    tResult getResponse(const V& SrcVolume, tSize x, tSize y, tSize z);

    //! Returns filter standard deviation.
    tSize getSize() const { return 3; }

};


//==============================================================================
/*
 * Methods templates.
 */

// Include file containing methods templates
#include "mdsAveraging.hxx"


} // namespace img
} // namespace mds

#endif // MDS_VF_AVERAGING_H

