//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2007 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    ImageFunctions/mdsHistogram.hxx     \n
 * Section: libImage                            \n
 * Date:    2007/04/17                          \n
 *
 * $Id: mdsHistogram.hxx 331 2007-04-17 14:43:06Z spanel $
 *
 * Description:
 * - Image histogram functions.
 */


//==============================================================================
/*
 * Functions templates.
 */

template <class I>
inline bool histogramEqualization(CImageBase<I>& Image)
{
    typedef typename I::tPixel tPixel;
    I& ImageImpl = Image.getImpl();

    // Useful constants
    static const tSize NumOfBins = 256;
    static const tPixel PixelMin = CPixelTraits<tPixel>::getPixelMin();
    static const tPixel PixelMax = CPixelTraits<tPixel>::getPixelMax();

    // Histogram of the image
    typedef CQuantizedHistogram<I> tHistogram;
    tHistogram Histogram(NumOfBins, PixelMin, PixelMax);
    if( !Histogram(ImageImpl) )
    {
        return false;
    }

    // Compute the cumulative histogram
    Histogram.cumulate();

    // Get the number of samples
    typename tHistogram::tBin Max = Histogram.getCount(Histogram.getSize() - 1);
    if( Max <= 0 )
    {
        return false;
    }

    // Histogram equalization
    double dNorm = double(PixelMax - PixelMin) / double(Max);
    for( tSize j = 0; j < ImageImpl.getYSize(); ++j )
    {
        for( tSize i = 0; i < ImageImpl.getXSize(); ++i )
        {
            tSize Index = Histogram.getIndex(ImageImpl(i,j));
            ImageImpl(i,j) = tPixel(dNorm * Histogram.getCount(Index) + PixelMin);
        }
    }

    // O.K.
    return true;
}

