//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2007 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    ImageFunctions/mdsHistogram.h       \n
 * Section: libImage                            \n
 * Date:    2007/04/17                          \n
 *
 * $Id: mdsHistogram.h 331 2007-04-17 14:43:06Z spanel $
 *
 * Description:
 * - Image histogram functions.
 */

#ifndef MDS_IMAGEFUNCTIONS_HISTOGRAM_H
#define MDS_IMAGEFUNCTIONS_HISTOGRAM_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsAssert.h>
#include <MDSTk/Math/mdsBase.h>

#include "../mdsImageBase.h"
#include "../mdsImageHistogram.h"

// STL
#include <cmath>


namespace mds
{
namespace img
{

//==============================================================================
/*
 * Global functions.
 */

//! Histogram equalization.
template <class I>
inline bool histogramEqualization(CImageBase<I>& Image);


//==============================================================================
/*
 * Functions templates.
 */

// Include the file containing functions templates.
#include "mdsHistogram.hxx"


} // namespace img
} // namespace mds

#endif // MDS_IMAGEFUNCTIONS_HISTOGRAM_H

