//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    ImageFilters/mdsSobel.h             \n
 * Section: libImage                            \n
 * Date:    2005/09/15                          \n
 *
 * $Id: mdsSobel.hxx 90 2006-09-13 12:22:57Z spanel $
 * 
 * Description:
 * - Sobel operator.
 */


//==============================================================================
/*
 * Methods templates.
 */

// Image filtering method
template <typename I, template <typename> class N>
bool CImageFilter<I, IF_SOBEL_X, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <typename I, template <typename> class N>
inline typename CImageFilter<I, IF_SOBEL_X, N>::tResult CImageFilter<I, IF_SOBEL_X, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Compute filter response
    tResult Value = Denom * (
                        2 * tResult(SrcImage.get(x + 1, y))
                        + tResult(SrcImage.get(x + 1, y - 1))
                        + tResult(SrcImage.get(x + 1, y + 1))
                        - 2 * tResult(SrcImage.get(x - 1, y))
                        - tResult(SrcImage.get(x - 1, y - 1))
                        - tResult(SrcImage.get(x - 1, y + 1))
                        );
    return Value;
}


// Image filtering method
template <typename I, template <typename> class N>
bool CImageFilter<I, IF_SOBEL_Y, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <typename I, template <typename> class N>
inline typename CImageFilter<I, IF_SOBEL_Y, N>::tResult CImageFilter<I, IF_SOBEL_Y, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Compute filter response
    tResult Value = Denom * (
                        2 * tResult(SrcImage.get(x, y + 1))
                        + tResult(SrcImage.get(x + 1, y + 1))
                        + tResult(SrcImage.get(x - 1, y + 1))
                        - 2 * tResult(SrcImage.get(x, y - 1))
                        - tResult(SrcImage.get(x + 1, y - 1))
                        - tResult(SrcImage.get(x - 1, y - 1))
                     );
    return Value;
}

