//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    ImageFilters/mdsRoberts.h           \n
 * Section: libImage                            \n
 * Date:    2005/09/15                          \n
 *
 * $Id: mdsRoberts.hxx 90 2006-09-13 12:22:57Z spanel $
 * 
 * Description:
 * - Roberts cross operator.
 */


//==============================================================================
/*
 * Methods templates.
 */

// Image filtering method
template <class I, template <typename> class N>
bool CImageFilter<I, IF_ROBERTS_X, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <class I, template <typename> class N>
typename CImageFilter<I, IF_ROBERTS_X, N>::tResult CImageFilter<I, IF_ROBERTS_X, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Compute filter response
    return tResult(SrcImage.get(x, y)) - tResult(SrcImage.get(x + 1, y + 1));
}


// Image filtering method
template <class I, template <typename> class N>
bool CImageFilter<I, IF_ROBERTS_Y, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <class I, template <typename> class N>
typename CImageFilter<I, IF_ROBERTS_Y, N>::tResult CImageFilter<I, IF_ROBERTS_Y, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Compute filter response
    return tResult(SrcImage.get(x, y)) - tResult(SrcImage.get(x - 1, y + 1));
}

