//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    ImageFilters/mdsLocalMoments.cpp    \n
 * Section: libImage                            \n
 * Date:    2006/03/30                          \n
 *
 * $Id: mdsLocalMoments.hxx 90 2006-09-13 12:22:57Z spanel $
 *
 * Description:
 * - Local moments (local texture features).
 */


//==============================================================================
/*
 * Methods templates.
 */

// Image filtering method
template <typename I, template <typename> class N>
bool CImageFilter<I, IF_LOCAL_MOMENT_00, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <typename I, template <typename> class N>
inline typename CImageFilter<I, IF_LOCAL_MOMENT_00, N>::tResult CImageFilter<I, IF_LOCAL_MOMENT_00, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Compute filter response
    tResult Value = Denom * (
                        tResult(SrcImage.get(x - 1, y -1))
                        + tResult(SrcImage.get(x, y - 1))
                        + tResult(SrcImage.get(x + 1, y - 1))
                        + tResult(SrcImage.get(x - 1, y))
                        + tResult(SrcImage.get(x, y))
                        + tResult(SrcImage.get(x + 1, y))
                        + tResult(SrcImage.get(x - 1, y + 1))
                        + tResult(SrcImage.get(x, y + 1))
                        + tResult(SrcImage.get(x + 1, y + 1))
                        );

    return Value;
}


// Image filtering method
template <typename I, template <typename> class N>
bool CImageFilter<I, IF_LOCAL_MOMENT_10, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <typename I, template <typename> class N>
inline typename CImageFilter<I, IF_LOCAL_MOMENT_10, N>::tResult CImageFilter<I, IF_LOCAL_MOMENT_10, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Compute filter response
    tResult Value = Denom * (
                        - tResult(SrcImage.get(x - 1, y -1))
                        - tResult(SrcImage.get(x, y - 1))
                        - tResult(SrcImage.get(x + 1, y - 1))
                        + tResult(SrcImage.get(x - 1, y + 1))
                        + tResult(SrcImage.get(x, y + 1))
                        + tResult(SrcImage.get(x + 1, y + 1))
                        );

    return Value;
}


// Image filtering method
template <typename I, template <typename> class N>
bool CImageFilter<I, IF_LOCAL_MOMENT_01, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <typename I, template <typename> class N>
inline typename CImageFilter<I, IF_LOCAL_MOMENT_01, N>::tResult CImageFilter<I, IF_LOCAL_MOMENT_01, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Compute filter response
    tResult Value = Denom * (
                        - tResult(SrcImage.get(x - 1, y - 1))
                        + tResult(SrcImage.get(x + 1, y - 1))
                        - tResult(SrcImage.get(x - 1, y))
                        + tResult(SrcImage.get(x + 1, y))
                        - tResult(SrcImage.get(x - 1, y + 1))
                        + tResult(SrcImage.get(x + 1, y + 1))
                        );

    return Value;
}


// Image filtering method
template <typename I, template <typename> class N>
bool CImageFilter<I, IF_LOCAL_MOMENT_11, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <typename I, template <typename> class N>
inline typename CImageFilter<I, IF_LOCAL_MOMENT_11, N>::tResult CImageFilter<I, IF_LOCAL_MOMENT_11, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Compute filter response
    tResult Value = Denom * (
                        tResult(SrcImage.get(x - 1, y -1))
                        - tResult(SrcImage.get(x + 1, y - 1))
                        - tResult(SrcImage.get(x - 1, y + 1))
                        + tResult(SrcImage.get(x + 1, y + 1))
                        );

    return Value;
}


// Image filtering method
template <typename I, template <typename> class N>
bool CImageFilter<I, IF_LOCAL_MOMENT_20, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <typename I, template <typename> class N>
inline typename CImageFilter<I, IF_LOCAL_MOMENT_20, N>::tResult CImageFilter<I, IF_LOCAL_MOMENT_20, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Compute filter response
    tResult Value = Denom * (
                        tResult(SrcImage.get(x - 1, y - 1))
                        + tResult(SrcImage.get(x, y - 1))
                        + tResult(SrcImage.get(x + 1, y - 1))
                        + tResult(SrcImage.get(x - 1, y + 1))
                        + tResult(SrcImage.get(x, y + 1))
                        + tResult(SrcImage.get(x + 1, y + 1))
                        );

    return Value;
}


// Image filtering method
template <typename I, template <typename> class N>
bool CImageFilter<I, IF_LOCAL_MOMENT_02, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <typename I, template <typename> class N>
inline typename CImageFilter<I, IF_LOCAL_MOMENT_02, N>::tResult CImageFilter<I, IF_LOCAL_MOMENT_02, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Compute filter response
    tResult Value = Denom * (
                        tResult(SrcImage.get(x - 1, y - 1))
                        + tResult(SrcImage.get(x + 1, y - 1))
                        + tResult(SrcImage.get(x - 1, y))
                        + tResult(SrcImage.get(x + 1, y))
                        + tResult(SrcImage.get(x - 1, y + 1))
                        + tResult(SrcImage.get(x + 1, y + 1))
                        );

    return Value;
}


// Image filtering method
template <typename I, template <typename> class N>
bool CImageFilter<I, IF_LOCAL_MOMENT_22, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <typename I, template <typename> class N>
inline typename CImageFilter<I, IF_LOCAL_MOMENT_22, N>::tResult CImageFilter<I, IF_LOCAL_MOMENT_22, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Compute filter response
    tResult Value = Denom * (tResult(SrcImage.get(x - 1, y - 1))
                        + tResult(SrcImage.get(x + 1, y - 1))
                        + tResult(SrcImage.get(x - 1, y + 1))
                        + tResult(SrcImage.get(x + 1, y + 1))
                        );

    return Value;
}

