//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    ImageFilters/mdsDoG.cpp             \n
 * Section: libImage                            \n
 * Date:    2005/10/07                          \n
 *
 * $Id: mdsDoG.hxx 90 2006-09-13 12:22:57Z spanel $
 * 
 * Description:
 * - Difference of Gaussians filter.
 */


//==============================================================================
/*
 * Methods templates.
 */

template <class I, template <typename> class N>
inline void CImageFilter<I, IF_DOG, N>::getSigmas(double& dSigma1, double& dSigma2) const
{
    dSigma1 = m_Gaussian1.setSigma();
    dSigma2 = m_Gaussian2.setSigma();
}


template <class I, template <typename> class N>
inline void CImageFilter<I, IF_DOG, N>::setSigmas(double dSigma1, double dSigma2)
{
    m_Gaussian1.setSigma(dSigma1);
    m_Gaussian2.setSigma(dSigma2);
}


// Image filtering method
template <class I, template <typename> class N>
bool CImageFilter<I, IF_DOG, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Gaussian smoothing of the input image
    tImage Filtered1(XCount, YCount);
    m_Gaussian1(SrcImage, Filtered1);

    // Gaussian smoothing of the input image
    tImage Filtered2(XCount, YCount);
    m_Gaussian2(SrcImage, Filtered2);

    // Compute difference of both smoothed images
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = tResult(Filtered2.get(x, y)) - tResult(Filtered1.get(x, y));
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}

