//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)      \n
 * Copyright (c) 2003-2005 by Michal Spanel       \n
 *
 * Author:    Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    ImageFilters/mdsConvolution.hxx       \n
 * Section: libImage                              \n
 * Date:    2005/09/08                            \n
 *
 * $Id: mdsConvolution.hxx 90 2006-09-13 12:22:57Z spanel $
 * 
 * Description:
 * - Convolution image filter.
 */


//==============================================================================
/*
 * Methods templates.
 */

// Image filtering method
template <class I, template <typename> class N>
bool CImageFilter<I, IF_CONVOLUTION, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}

