//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    ImageFilters/mdsAveraging.h         \n
 * Section: libImage                            \n
 * Date:    2005/09/08                          \n
 *
 * $Id: mdsAveraging.hxx 90 2006-09-13 12:22:57Z spanel $
 * 
 * Description:
 * - Averaging image filters.
 */


//==============================================================================
/*
 * Methods templates.
 */

// Filter kernel
template <class I, template <typename> class N>
const CKernel2D::tData CImageFilter<I, IF_AVG_3, N>::KERNEL[] =
{
    1.0f,  2.0f,  1.0f,
    2.0f,  4.0f,  2.0f,
    1.0f,  2.0f,  1.0f
};


// Image filtering method
template <class I, template <typename> class N>
bool CImageFilter<I, IF_AVG_3, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <class I, template <typename> class N>
typename CImageFilter<I, IF_AVG_3, N>::tResult CImageFilter<I, IF_AVG_3, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Filter kernel
    static const CKernel2D Kernel(KERNEL, getSize());

    // Compute filter response
    return Denom * convolve<tResult>(SrcImage, x, y, Kernel);
}


// Filter kernel
template <class I, template <typename> class N>
const CKernel2D::tData CImageFilter<I, IF_AVG_5, N>::KERNEL[] =
{
    1.0f,  2.0f,  3.0f,  2.0f,  1.0f,
    2.0f,  4.0f,  6.0f,  4.0f,  2.0f,
    3.0f,  6.0f,  9.0f,  6.0f,  3.0f,
    2.0f,  4.0f,  6.0f,  4.0f,  2.0f,
    1.0f,  2.0f,  3.0f,  2.0f,  1.0f
};


// Image filtering method
template <class I, template <typename> class N>
bool CImageFilter<I, IF_AVG_5, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <class I, template <typename> class N>
typename CImageFilter<I, IF_AVG_5, N>::tResult CImageFilter<I, IF_AVG_5, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Filter kernel
    static const CKernel2D Kernel(KERNEL, getSize());

    // Compute filter response
    return Denom * convolve<tResult>(SrcImage, x, y, Kernel);
}


// Filter kernel
template <class I, template <typename> class N>
const CKernel2D::tData CImageFilter<I, IF_AVG_7, N>::KERNEL[] =
{
    1.0f,  2.0f,  3.0f,  4.0f,  3.0f,  2.0f,  1.0f,
    2.0f,  4.0f,  6.0f,  8.0f,  6.0f,  4.0f,  2.0f,
    3.0f,  6.0f,  9.0f, 12.0f,  9.0f,  6.0f,  3.0f,
    4.0f,  8.0f, 12.0f, 16.0f, 12.0f,  8.0f,  4.0f,
    3.0f,  6.0f,  9.0f, 12.0f,  9.0f,  6.0f,  3.0f,
    2.0f,  4.0f,  6.0f,  8.0f,  6.0f,  4.0f,  2.0f,
    1.0f,  2.0f,  3.0f,  4.0f,  3.0f,  2.0f,  1.0f
};


// Image filtering method
template <class I, template <typename> class N>
bool CImageFilter<I, IF_AVG_7, N>::operator()(const I& SrcImage, I& DstImage)
{
    // Image size
    tSize XCount = mds::math::getMin(SrcImage.getXSize(), DstImage.getXSize());
    tSize YCount = mds::math::getMin(SrcImage.getYSize(), DstImage.getYSize());

    // Filter the image
    for( tSize y = 0; y < YCount; ++y )
    {
        for( tSize x = 0; x < XCount; ++x )
        {
            tResult Value = getResponse(SrcImage, x, y);
            DstImage.set(x, y, norm::normalize(Value));
        }
    }

    // O.K.
    return true;
}


// Image filter response
template <class I, template <typename> class N>
typename CImageFilter<I, IF_AVG_7, N>::tResult CImageFilter<I, IF_AVG_7, N>::getResponse(const I& SrcImage, tSize x, tSize y)
{
    // Output normalization
    static const tResult Denom = 1.0f / DENOM;

    // Filter kernel
    static const CKernel2D Kernel(KERNEL, getSize());

    // Compute filter response
    return Denom * convolve<tResult>(SrcImage, x, y, Kernel);
}

