//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsWarning.h                        \n
 * Section: libBase                             \n
 * Date:    2003/10/23                          \n
 *
 * $Id: mdsWarning.h 116 2006-10-20 08:51:07Z spanel $
 * 
 * Description:
 * - Warning class.
 */

#ifndef MDS_WARNING_H
#define MDS_WARNING_H

#include "mdsSetup.h"
#include "mdsException.h"


namespace mds
{

//==============================================================================
/*!
 * Class encapsulating an exception origin and description.
 */
class CWarning : public CException
{
public:
    //! Constructor.
    CWarning(const std::string& sReason,
             const std::string& sFilename,
             int iLine
            )
            : CException(sReason, sFilename, iLine)
    {}

    //! Exception copy constructor.
    CWarning(const CWarning& w) : CException(w) {}

    //! Virtual destructor.
    virtual ~CWarning() throw() {}


    //! Writes warning description into the output stream
    //! in human readable form.
    virtual void print(std::ostream& Stream) const;

    //! Writes warning description into the output stream.
    friend std::ostream& operator <<(std::ostream& Stream, const CWarning& Warning);
};


//==============================================================================
/*
 * Several macro definitions.
 */

//! Macro that creates warning with 'Name' as an description.
//! - File and line parameters acquired from compiler.
#define MDS_WARNING(Name)           mds::CWarning(Name, __FILE__, __LINE__)

//! Creates and throws warning with 'Name' as an description.
//! - File and line parameters acquired from compiler.
#define MDS_THROW_WARNING(Name)     throw mds::CWarning(Name, __FILE__, __LINE__)

//! Catch block for handling the CWarning exception.
//! - Writes info about it to the global log and cerr.
#define MDS_CATCH_WARNING(ModuleName) \
    catch( mds::CWarning& Warning ) \
    { \
        MDS_LOG(Warning); \
        MDS_CERR('<' << ModuleName << "> Warning: see log for details" << std::endl); \
    }


} // namespace mds

#endif // MDS_WARNING_H

