//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsTemplates.h                      \n
 * Section: libBase                             \n
 * Date:    2004/12/13                          \n
 *
 * $Id: mdsTemplates.h 110 2006-10-12 21:25:52Z spanel $
 * 
 * Description:
 * - Basic templates.
 */

#ifndef MDS_TEMPLATES_H
#define MDS_TEMPLATES_H

#include "mdsSetup.h"


namespace mds
{

//==============================================================================
/*!
 * Used as a placeholder for "no type here".
 */
struct tNull {};


//==============================================================================
/*!
 * Selects one of two types based upon a boolean constant.
 * Result evaluates to T if Flag is true, and to U otherwise.
 */
template <bool Flag, typename T, typename U>
struct SSelect
{
    typedef T RESULT;
};


//! Partial specialization for false 'Flag'.
template <typename T, typename U>
struct SSelect<false, T, U>
{
    typedef U RESULT;
};


//==============================================================================
/*!
 * Selects one of two integers based upon a boolean constant.
 * Result evaluates to T if Flag is true, and to U otherwise.
 */
template <bool Flag, int T, int U>
struct SSelectInt
{
    enum { RESULT = T };
};


//! Partial specialization for false 'Flag'.
template <int T, int U>
struct SSelectInt<false, T, U>
{
    enum { RESULT = U };
};


//==============================================================================
/*!
 * Checks if template parameters T and U are identical.
 */
template <typename T, typename U>
struct SCheckIdentity
{
    enum { RESULT = false };
};


//! Partial specialization.
template <typename T>
struct SCheckIdentity<T, T>
{
    enum { RESULT = true };
};


} // namespace mds

#endif // MDS_TEMPLATES_H

