//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)	\n
 * Copyright (c) 2003-2006 by Michal Spanel		\n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz	\n
 * File:    mdsStaticData.hxx					\n
 * Section: libBase								\n
 * Date:    2006/02/15							\n
 *
 * $Id: mdsStaticData.hxx 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Template providing data allocation functions.
 * - Implemented via static array.
 */

//==============================================================================
/*
 * Methods templates.
 */

// Default constructor
template <typename T, tSize M>
inline CStaticData<T,M>::CStaticData()
{
}


// Constructor initializes the data
template <typename T, tSize M>
inline CStaticData<T,M>::CStaticData(const tData& Value)
{
    memSet(m_pData, Value, M);
}


// Constructor that copies a specified data
template <typename T, tSize M>
inline CStaticData<T,M>::CStaticData(tConstDataPtr pData, tSize Size)
{
    MDS_ASSERT(Size >= 0 && pData);

    memCopy(m_pData, pData, (Size < M) ? Size : M);
}


// Constructor copies a given data
template <typename T, tSize M>
inline CStaticData<T,M>::CStaticData(const CStaticData<T,M>& Data)
{
    memCopy(m_pData, Data.m_pData, M);
}


// Destructor
template <typename T, tSize M>
inline CStaticData<T,M>::~CStaticData()
{
}


// Assignment operator
template <typename T, tSize M>
inline CStaticData<T,M>& CStaticData<T,M>::operator =(const CStaticData<T,M>& Data)
{
    if( this != &Data )
    {
        memCopy(m_pData, Data.m_pData, M);
    }
    return *this;
}


// Constructor initializes the data
template <typename T, tSize M>
inline void CStaticData<T,M>::create(const tData& Value)
{
    memSet(m_pData, Value, M);
}


// Copies the specified data to it
template <typename T, tSize M>
inline void CStaticData<T,M>::create(tConstDataPtr pData, tSize Size)
{
    MDS_ASSERT(Size >= 0 && pData);

    memCopy(m_pData, pData, (Size < M) ? Size : M);
}


// Allocates new memory and copies the specified data
template <typename T, tSize M>
inline void CStaticData<T,M>::create(const CStaticData<T,M>& Data)
{
    memCopy(m_pData, Data.m_pData, M);
}

