//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsSetup.h                          \n
 * Section: libBase                             \n
 * Date:    2004/12/06                          \n
 *
 * $Id: mdsSetup.h 485 2007-09-26 08:22:06Z spanel $
 *
 * Description:
 * - General compilation settings and options.
 * - Every header file must include it!
 */

#ifndef MDS_SETUP_H
#define MDS_SETUP_H

// Include configuration file 
#include <MDSTk/configure.h>

// Include platform dependent definitions
#include <MDSTk/System/mdsEnvironment.h>


//=============================================================================
/*
 * Check MDSTk settings.
 */

// Check for C++ compiler.
#ifndef __cplusplus
#   error C++ compiler must be used!
#endif

// Check that one of the macros _LINUX or _WIN32 is defined.
#if defined(_WIN32) && defined(_LINUX)
#   error Macros _WIN32 and _LINUX cannot be defined simultaneously!
#elif !defined(_WIN32) && !defined(_LINUX)
#   error Please, use one of the macros _WIN32 or _LINUX to specify your OS!
#endif


#endif // MDS_SETUP_H
