//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsIdentifier.h                     \n
 * Section: libBase                             \n
 * Date:    2005/09/06                          \n
 *
 * $Id: mdsIdentifier.h 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Template identifier definition and creation.
 */

#ifndef MDS_IDENTIFIER_H
#define MDS_IDENTIFIER_H

#include "mdsSetup.h"
#include "mdsObject.h"

// STL
#include <string>


namespace mds
{

//==============================================================================
/*
 * Global definitions.
 */

//! Identifier type used to declare templates whose instances
//! are specialized by using identifiers.
#define tIdentifier             typename


//==============================================================================
/*
 * Several usefull macros.
 */

//! Declares an identifier.
//! - Parameter 'Id' is a name of the identifier.
#define MDS_DECLARE_ID(Id)      struct Id { MDS_STATIC_NAME(Id); }


} // namespace mds

#endif // MDS_IDENTIFIER_H

