//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    Slice2Text.h                        \n
 * Section: samples                             \n
 * Date:    2006/10/30                          \n
 *
 * $Id:$
 *
 * File description:
 * - Sample module.
 */

#ifndef MDS_SLICE2TEXT_H
#define MDS_SLICE2TEXT_H

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Sample module providing conversion of an input image to text (ASCII art).
 */
class CSlice2Text : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CSlice2Text);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CSlice2Text);

public:
    //! Default constructor.
    CSlice2Text(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CSlice2Text();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing an usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CSlice2Text::tSmartPtr    CSlice2TextPtr;


#endif // MDS_SLICE2TEXT_H

