//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsASCIITable.cpp                   \n
 * Section: samples                             \n
 * Date:    2006/10/30                          \n
 *
 * $Id:$
 *
 * File description:
 * - Sample application.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Math/mdsMatrix.h>
#include <MDSTk/Math/mdsMatrixFunctions.h>

// STL
#include <iostream>


int main(int argc, char *argv[])
{
    // Matrix/table of characters
    typedef mds::math::CMatrix<unsigned char> tTable;

    // Fill the table
    tTable Table(10, 25, ' ');
    tTable::tIterator itEnd = Table.getEnd();
    tTable::tIterator it = Table.getBegin();
    for( unsigned char ucValue = 32; it != itEnd; ++it, ++ucValue )
    {
        *it = ucValue;
        
        if( ucValue == 255 )
        {
            break;
        }
    }

    // Print the table
    std::cout << "Table of ASCII characters starting with space:" << std::endl;
    std::cout << Table << std::endl;

    return 0;
}

