//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) yyyy by ...                    \n
 *
 * Author:  ..., ...@...                        \n
 * File:    mdsViewApp.h                        \n
 * Section: MyView                              \n
 * Date:    yyyy/mm/dd                          \n
 *
 * $Id:$
 *
 * Description:
 * - 
 */

#ifndef MDS_MYVIEW_H
#define MDS_MYVIEW_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsView.h>


//==============================================================================
/*!
 * View description ...
 */
class CViewApp : public mds::mod::CView
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CMyView);

    //! Smart pointer type.
    //! - declares type tSmartPtr.
    MDS_SHAREDPTR(CMyView);

public:
    //! Default constructor
    CMyView(const std::string& sDescription);

    //! Virtual destructor
    virtual ~CMyView();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing a usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:
    // User defined protected members ... 
};


//==============================================================================
/*!
 * Smart pointer to the view application.
 */
typedef CMyView::tSmartPtr  CMyViewPtr;


#endif // MDS_MYVIEW_H
