//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) yyyy by ...                    \n
 *
 * Author:  ..., ...@...                        \n
 * File:    mdsViewApp.cpp                      \n
 * Section: MyView                              \n
 * Date:    yyyy/mm/dd                          \n
 *
 * $Id:$
 *
 * Description:
 * - 
 */

#include "mdsMyView.h"

// STL
#include <iostream>
#include <string>


//==============================================================================
/*
 * Global module constants.
 */

//! Module description.
const std::string MODULE_DESCRIPTION    = "Brief module description ...";

//! Additional command line arguments.
const std::string MODULE_ARGUMENTS        = "";


//==============================================================================
/*
 * Implementation of the class CMyView.
 */
CMyView::CMyView(const std::string& sDescription)
    : mds::mod::CView(sDescription)
{
    allowArguments(MODULE_ARGUMENTS);
}


CMyView::~CMyView()
{
}


bool CMyView::startup()
{
    // Note
    MDS_LOG_NOTE("Module startup");

    // Test of existence of input channel
    if( getNumOfInputs() != 1 )
    {
        MDS_CERR('<' << m_sFilename << "> Wrong number of input channels" << std::endl);
        return false;
    }

    // O.K.
    return true;
}


bool CMyView::main()
{
    // Note
    MDS_LOG_NOTE("Module main function");

    // Input channel
    mds::CChannel *pIChannel = getInput(0);

    // Is any input?
    if( !pIChannel->isConnected() )
    {
        return false;
    }

    // Wait for data
    if( pIChannel->wait(1000) )
    {
        // Read and process data from the input channel
    }
    else
    {
        MDS_LOG_NOTE("Wait timeout");\
    }

    return false;
}


void CMyView::shutdown()
{
    // Note
    MDS_LOG_NOTE("Module shutdown");
}


void CMyView::writeExtendedUsage(std::ostream& Stream)
{
    MDS_CERR(std::endl);
    MDS_CERR("Extended usage:" << std::endl);
    MDS_CERR("Options:" << std::endl);
}


//==============================================================================
/*
 * Function main() which creates and executes view application.
 */
int main(int argc, char *argv[])
{
    // Creation of a view module using smart pointer
    CMyViewPtr spView(new CMyView(MODULE_DESCRIPTION));

    // Initialize and run the view
    if( spView->init(argc, argv) )
    {
        spView->run();
    }

    // Console application finished
    return 0;
}
