//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) yyyy by ...                    \n
 *
 * Author:  ..., ...@...                        \n
 * File:    mdsMyModule.h                       \n
 * Section: MyModule                            \n
 * Date:    yyyy/mm/dd                          \n
 *
 * $Id:$
 *
 * Description:
 * -
 */

#ifndef MDS_MYMODULE_H
#define MDS_MYMODULE_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module description ...
 */
class CMyModule : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CMyModule);

    //! Smart pointer type.
    //! - declares type tSmartPtr.
    MDS_SHAREDPTR(CMyModule);

public:
    //! Default constructor.
    CMyModule(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CMyModule();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing a usage statement
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:
    // User defined protected members ...
};


//==============================================================================
/*!
 * Smart pointer to the module application.
 */
typedef CMyModule::tSmartPtr        CMyModulePtr;


#endif // MDS_MYMODULE_H
