//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) yyyy by ...                    \n
 *
 * Author:  ..., ...@...                        \n
 * File:    mdsMyModule.cpp                     \n
 * Section: MyModule                            \n
 * Date:    yyyy/mm/dd                          \n
 *
 * $Id:$
 *
 * Description:
 * - 
 */

#include "mdsMyModule.h"

// STL
#include <iostream>
#include <string>


//==============================================================================
/*
 * Global module constants
 */

//! Module description.
const std::string MODULE_DESCRIPTION    = "Brief module description ...";

//! Additional command line arguments.
const std::string MODULE_ARGUMENTS      = "";


//==============================================================================
/*
 * Implementation of the class CMyModule
 */
CMyModule::CMyModule(const std::string& sDescription)
    : mds::mod::CModule(sDescription)
{
    allowArguments(MODULE_ARGUMENTS);
}


CMyModule::~CMyModule()
{
}


bool CMyModule::startup()
{
    // Note
    MDS_LOG_NOTE("Module startup");

    // Test of existence of input and output channel
    if( getNumOfInputs() != 1 || getNumOfOutputs() != 1 )
    {
        MDS_CERR('<' << m_sFilename << "> Wrong number of input and output channels" << std::endl);
        return false;
    }

    // O.K.
    return true;
}


bool CMyModule::main()
{
    // Note
    MDS_LOG_NOTE("Module main function");

    // I/O channels
    mds::CChannel *pIChannel = getInput(0);
    mds::CChannel *pOChannel = getOutput(0);

    // Is any input?
    if( !pIChannel->isConnected() )
    {
        return false;
    }

    // Wait for data
    if( pIChannel->wait(1000) )
    {
        // Read and process data from the input channel
    }
    else
    {
        MDS_LOG_NOTE("Wait timeout");
    }

    // Returning 'true' means to continue processing the input channel
    return true;
}


void CMyModule::shutdown()
{
    // Note
    MDS_LOG_NOTE("Module shutdown");
}


void CMyModule::writeExtendedUsage(std::ostream& Stream)
{
    MDS_CERR(std::endl);
    MDS_CERR("Extended usage:" << std::endl);
    MDS_CERR("Options:" << std::endl);
}


//==============================================================================
/*
 * Function main() which creates and executes console application.
 */
int main(int argc, char *argv[])
{
    // Module creation using smart pointer
    CMyModulePtr spModule(new CMyModule(MODULE_DESCRIPTION));

    // Initialize and execute the module
    if( spModule->init(argc, argv) )
    {
        spModule->run();
    }

    // Console application finished
    return 0;
}
