/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import tools.TestReport;

public class TestStatistics {
    public static String helpText = "-----------------------------------------------------------\nANPR Statistics Generator\nCopyright (c) Ondrej Martinsky, 2006-2007\n\nLicensed under the Educational Community License,\n\nCommand line arguments\n\n    -help         Displays this help\n    -i <file>     Create statistics for test file\n\nTest file must be have a CSV format\nEach row must contain name of analysed snapshot,\nreal plate and recognized plate string\nExample : \n001.jpg, 1B01234, 1B012??";

    public static void main(String[] args) {
        if (args.length == 2 && args[0].equals("-i")) {
            try {
                String line;
                File f = new File(args[1]);
                BufferedReader input = new BufferedReader(new FileReader(f));
                int lineCount = 0;
                TestReport testReport = new TestReport();
                while ((line = input.readLine()) != null) {
                    ++lineCount;
                    String[] split = line.split(",", 4);
                    if (split.length != 3) {
                        System.out.println("Warning: line " + lineCount + " contains invalid CSV data (skipping)");
                        continue;
                    }
                    TestReport testReport2 = testReport;
                    testReport2.getClass();
                    testReport.addRecord(testReport2.new TestReport.TestRecord(split[0], split[1], split[2]));
                }
                input.close();
                testReport.printStatistics();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
        } else {
            System.out.println(helpText);
        }
    }
}

