/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.recognizer;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javaanpr.imageanalysis.Char;
import javaanpr.intelligence.Intelligence;
import javaanpr.recognizer.CharacterRecognizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnnPatternClassificator
extends CharacterRecognizer {
    Vector<Vector<Double>> learnVectors;

    public KnnPatternClassificator() throws IOException {
        String path = Intelligence.configurator.getPathProperty("char_learnAlphabetPath");
        String alphaString = "0123456789abcdefghijklmnopqrstuvwxyz";
        this.learnVectors = new Vector();
        for (int i = 0; i < alphaString.length(); ++i) {
            this.learnVectors.add(null);
        }
        File folder = new File(path);
        for (String fileName : folder.list()) {
            int alphaPosition = alphaString.indexOf(fileName.toLowerCase().charAt(0));
            if (alphaPosition == -1) continue;
            Char imgChar = new Char(path + File.separator + fileName);
            imgChar.normalize();
            this.learnVectors.set(alphaPosition, imgChar.extractFeatures());
        }
        for (int i = 0; i < alphaString.length(); ++i) {
            if (this.learnVectors.elementAt(i) != null) continue;
            throw new IOException("Warning : alphabet in " + path + " is not complete");
        }
    }

    @Override
    public CharacterRecognizer.RecognizedChar recognize(Char chr) throws Exception {
        Vector<Double> tested = chr.extractFeatures();
        boolean minx = false;
        float minfx = Float.POSITIVE_INFINITY;
        CharacterRecognizer.RecognizedChar recognized = new CharacterRecognizer.RecognizedChar();
        for (int x = 0; x < this.learnVectors.size(); ++x) {
            float fx = this.simplifiedEuclideanDistance(tested, this.learnVectors.elementAt(x));
            CharacterRecognizer.RecognizedChar recognizedChar = recognized;
            recognizedChar.getClass();
            recognized.addPattern(recognizedChar.new CharacterRecognizer.RecognizedChar.RecognizedPattern(alphabet[x], fx));
        }
        recognized.sort(0);
        return recognized;
    }

    public float difference(Vector<Double> vectorA, Vector<Double> vectorB) {
        float diff = 0.0f;
        for (int x = 0; x < vectorA.size(); ++x) {
            diff = (float)((double)diff + Math.abs(vectorA.elementAt(x) - vectorB.elementAt(x)));
        }
        return diff;
    }

    public float simplifiedEuclideanDistance(Vector<Double> vectorA, Vector<Double> vectorB) {
        float diff = 0.0f;
        for (int x = 0; x < vectorA.size(); ++x) {
            float partialDiff = (float)Math.abs(vectorA.elementAt(x) - vectorB.elementAt(x));
            diff += partialDiff * partialDiff;
        }
        return diff;
    }
}

