/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.awt.image.BufferedImage;
import javaanpr.imageanalysis.Photo;

public class Statistics {
    public float maximum;
    public float minimum;
    public float average;
    public float dispersion;

    Statistics(BufferedImage bi) {
        this(new Photo(bi));
    }

    Statistics(Photo photo) {
        float sum = 0.0f;
        float sum2 = 0.0f;
        int w = photo.getWidth();
        int h = photo.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                float pixelValue = photo.getBrightness(x, y);
                this.maximum = Math.max(pixelValue, this.maximum);
                this.minimum = Math.min(pixelValue, this.minimum);
                sum += pixelValue;
                sum2 += pixelValue * pixelValue;
            }
        }
        int count = w * h;
        this.average = sum / (float)count;
        this.dispersion = sum2 / (float)count - this.average * this.average;
    }

    public float thresholdBrightness(float value, float coef) {
        float out = value > this.average ? coef + (1.0f - coef) * (value - this.average) / (this.maximum - this.average) : (1.0f - coef) * (value - this.minimum) / (this.average - this.minimum);
        return out;
    }
}

