/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javaanpr.imageanalysis.Graph;
import javaanpr.imageanalysis.Plate;
import javaanpr.intelligence.Intelligence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateVerticalGraph
extends Graph {
    private static double peakFootConstant = Intelligence.configurator.getDoubleProperty("plateverticalgraph_peakfootconstant");
    Plate handle;

    public PlateVerticalGraph(Plate handle) {
        this.handle = handle;
    }

    public Vector<Graph.Peak> findPeak(int count) {
        for (int i = 0; i < this.yValues.size(); ++i) {
            this.yValues.set(i, Float.valueOf(((Float)this.yValues.elementAt(i)).floatValue() - this.getMinValue()));
        }
        Vector<Graph.Peak> outPeaks = new Vector<Graph.Peak>();
        for (int c = 0; c < count; ++c) {
            float maxValue = 0.0f;
            int maxIndex = 0;
            for (int i = 0; i < this.yValues.size(); ++i) {
                if (!this.allowedInterval(outPeaks, i) || !(((Float)this.yValues.elementAt(i)).floatValue() >= maxValue)) continue;
                maxValue = ((Float)this.yValues.elementAt(i)).floatValue();
                maxIndex = i;
            }
            if ((double)((Float)this.yValues.elementAt(maxIndex)).floatValue() < 0.05 * (double)super.getMaxValue()) break;
            int leftIndex = this.indexOfLeftPeakRel(maxIndex, peakFootConstant);
            int rightIndex = this.indexOfRightPeakRel(maxIndex, peakFootConstant);
            outPeaks.add(new Graph.Peak(Math.max(0, leftIndex), maxIndex, Math.min(this.yValues.size() - 1, rightIndex)));
        }
        Collections.sort(outPeaks, new PeakComparer(this));
        this.peaks = outPeaks;
        return outPeaks;
    }

    public class PeakComparer
    implements Comparator {
        PlateVerticalGraph graphHandle = null;

        public PeakComparer(PlateVerticalGraph graph) {
            this.graphHandle = graph;
        }

        private float getPeakValue(Object peak) {
            return ((Float)this.graphHandle.yValues.elementAt(((Graph.Peak)peak).getCenter())).floatValue();
        }

        public int compare(Object peak1, Object peak2) {
            double comparison = this.getPeakValue(peak2) - this.getPeakValue(peak1);
            if (comparison < 0.0) {
                return -1;
            }
            if (comparison > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

