/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javaanpr.imageanalysis.Graph;
import javaanpr.imageanalysis.Plate;
import javaanpr.intelligence.Intelligence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateGraph
extends Graph {
    Plate handle;
    private static double plategraph_rel_minpeaksize = Intelligence.configurator.getDoubleProperty("plategraph_rel_minpeaksize");
    private static double peakFootConstant = Intelligence.configurator.getDoubleProperty("plategraph_peakfootconstant");

    public PlateGraph(Plate handle) {
        this.handle = handle;
    }

    public Vector<Graph.Peak> findPeaks(int count) {
        Graph.Peak last;
        int leftIndex;
        Vector<Graph.Peak> spacesTemp = new Vector<Graph.Peak>();
        float diffGVal = 2.0f * this.getAverageValue() - this.getMaxValue();
        Vector<Float> yValuesNew = new Vector<Float>();
        for (Float f : this.yValues) {
            yValuesNew.add(Float.valueOf(f.floatValue() - diffGVal));
        }
        this.yValues = yValuesNew;
        this.deActualizeFlags();
        for (int c = 0; c < count; ++c) {
            float maxValue = 0.0f;
            int maxIndex = 0;
            for (int i = 0; i < this.yValues.size(); ++i) {
                if (!this.allowedInterval(spacesTemp, i) || !(((Float)this.yValues.elementAt(i)).floatValue() >= maxValue)) continue;
                maxValue = ((Float)this.yValues.elementAt(i)).floatValue();
                maxIndex = i;
            }
            if ((double)((Float)this.yValues.elementAt(maxIndex)).floatValue() < plategraph_rel_minpeaksize * (double)this.getMaxValue()) break;
            leftIndex = this.indexOfLeftPeakRel(maxIndex, peakFootConstant);
            int rightIndex = this.indexOfRightPeakRel(maxIndex, peakFootConstant);
            spacesTemp.add(new Graph.Peak(Math.max(0, leftIndex), maxIndex, Math.min(this.yValues.size() - 1, rightIndex)));
        }
        Vector<Graph.Peak> spaces = new Vector<Graph.Peak>();
        for (Graph.Peak p : spacesTemp) {
            if (p.getDiff() >= 1 * this.handle.getHeight()) continue;
            spaces.add(p);
        }
        Collections.sort(spaces, new SpaceComparer(this.yValues));
        Vector<Graph.Peak> chars = new Vector<Graph.Peak>();
        if (spaces.size() != 0) {
            int minIndex = this.getMinValueIndex(0, ((Graph.Peak)spaces.elementAt(0)).getCenter());
            leftIndex = 0;
            Graph.Peak first = new Graph.Peak(leftIndex, ((Graph.Peak)spaces.elementAt(0)).getCenter());
            if (first.getDiff() > 0) {
                chars.add(first);
            }
        }
        for (int i = 0; i < spaces.size() - 1; ++i) {
            int left = ((Graph.Peak)spaces.elementAt(i)).getCenter();
            int right = ((Graph.Peak)spaces.elementAt(i + 1)).getCenter();
            chars.add(new Graph.Peak(left, right));
        }
        if (spaces.size() != 0 && (last = new Graph.Peak(((Graph.Peak)spaces.elementAt(spaces.size() - 1)).getCenter(), this.yValues.size() - 1)).getDiff() > 0) {
            chars.add(last);
        }
        this.peaks = chars;
        return chars;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpaceComparer
    implements Comparator {
        Vector<Float> yValues = null;

        public SpaceComparer(Vector<Float> yValues) {
            this.yValues = yValues;
        }

        private float getPeakValue(Object peak) {
            return ((Graph.Peak)peak).getCenter();
        }

        public int compare(Object peak1, Object peak2) {
            double comparison = this.getPeakValue(peak2) - this.getPeakValue(peak1);
            if (comparison < 0.0) {
                return 1;
            }
            if (comparison > 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

