/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Vector;
import javaanpr.imageanalysis.Char;
import javaanpr.imageanalysis.Graph;
import javaanpr.imageanalysis.Photo;
import javaanpr.imageanalysis.PlateGraph;
import javaanpr.imageanalysis.PlateHorizontalGraph;
import javaanpr.imageanalysis.PlateVerticalGraph;
import javaanpr.imageanalysis.PositionInPlate;
import javaanpr.intelligence.Intelligence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plate
extends Photo {
    public static Graph.ProbabilityDistributor distributor = new Graph.ProbabilityDistributor(0.0f, 0.0f, 0, 0);
    private static int numberOfCandidates = Intelligence.configurator.getIntProperty("intelligence_numberOfChars");
    private static int horizontalDetectionType = Intelligence.configurator.getIntProperty("platehorizontalgraph_detectionType");
    private PlateGraph graphHandle = null;
    public Plate plateCopy;

    public Plate() {
        this.image = null;
    }

    public Plate(BufferedImage bi) {
        super(bi);
        this.plateCopy = new Plate(Plate.duplicateBufferedImage(this.image), true);
        this.plateCopy.adaptiveThresholding();
    }

    public Plate(BufferedImage bi, boolean isCopy) {
        super(bi);
    }

    public BufferedImage renderGraph() {
        this.computeGraph();
        return this.graphHandle.renderHorizontally(this.getWidth(), 100);
    }

    private Vector<Graph.Peak> computeGraph() {
        if (this.graphHandle != null) {
            return this.graphHandle.peaks;
        }
        this.graphHandle = this.histogram(this.plateCopy.getBi());
        this.graphHandle.applyProbabilityDistributor(distributor);
        this.graphHandle.findPeaks(numberOfCandidates);
        return this.graphHandle.peaks;
    }

    public Vector<Char> getChars() {
        Vector<Char> out = new Vector<Char>();
        Vector<Graph.Peak> peaks = this.computeGraph();
        for (int i = 0; i < peaks.size(); ++i) {
            Graph.Peak p = peaks.elementAt(i);
            if (p.getDiff() <= 0) continue;
            out.add(new Char(this.image.getSubimage(p.getLeft(), 0, p.getDiff(), this.image.getHeight()), this.plateCopy.image.getSubimage(p.getLeft(), 0, p.getDiff(), this.image.getHeight()), new PositionInPlate(p.getLeft(), p.getRight())));
        }
        return out;
    }

    @Override
    public Plate clone() {
        return new Plate(Plate.duplicateBufferedImage(this.image));
    }

    public void horizontalEdgeBi(BufferedImage image) {
        BufferedImage imageCopy = Plate.duplicateBufferedImage(image);
        float[] data = new float[]{-1.0f, 0.0f, 1.0f};
        new ConvolveOp(new Kernel(1, 3, data), 1, null).filter(imageCopy, image);
    }

    public void normalize() {
        Plate clone1 = this.clone();
        clone1.verticalEdgeDetector(clone1.getBi());
        PlateVerticalGraph vertical = clone1.histogramYaxis(clone1.getBi());
        this.image = this.cutTopBottom(this.image, vertical);
        this.plateCopy.image = this.cutTopBottom(this.plateCopy.image, vertical);
        Plate clone2 = this.clone();
        if (horizontalDetectionType == 1) {
            clone2.horizontalEdgeDetector(clone2.getBi());
        }
        PlateHorizontalGraph horizontal = clone1.histogramXaxis(clone2.getBi());
        this.image = this.cutLeftRight(this.image, horizontal);
        this.plateCopy.image = this.cutLeftRight(this.plateCopy.image, horizontal);
    }

    private BufferedImage cutTopBottom(BufferedImage origin, PlateVerticalGraph graph) {
        graph.applyProbabilityDistributor(new Graph.ProbabilityDistributor(0.0f, 0.0f, 2, 2));
        Graph.Peak p = graph.findPeak(3).elementAt(0);
        return origin.getSubimage(0, p.getLeft(), this.image.getWidth(), p.getDiff());
    }

    private BufferedImage cutLeftRight(BufferedImage origin, PlateHorizontalGraph graph) {
        graph.applyProbabilityDistributor(new Graph.ProbabilityDistributor(0.0f, 0.0f, 2, 2));
        Vector<Graph.Peak> peaks = graph.findPeak(3);
        if (peaks.size() != 0) {
            Graph.Peak p = peaks.elementAt(0);
            return origin.getSubimage(p.getLeft(), 0, p.getDiff(), this.image.getHeight());
        }
        return origin;
    }

    public PlateGraph histogram(BufferedImage bi) {
        PlateGraph graph = new PlateGraph(this);
        for (int x = 0; x < bi.getWidth(); ++x) {
            float counter = 0.0f;
            for (int y = 0; y < bi.getHeight(); ++y) {
                counter += Plate.getBrightness(bi, x, y);
            }
            graph.addPeak(counter);
        }
        return graph;
    }

    private PlateVerticalGraph histogramYaxis(BufferedImage bi) {
        PlateVerticalGraph graph = new PlateVerticalGraph(this);
        int w = bi.getWidth();
        int h = bi.getHeight();
        for (int y = 0; y < h; ++y) {
            float counter = 0.0f;
            for (int x = 0; x < w; ++x) {
                counter += Plate.getBrightness(bi, x, y);
            }
            graph.addPeak(counter);
        }
        return graph;
    }

    private PlateHorizontalGraph histogramXaxis(BufferedImage bi) {
        PlateHorizontalGraph graph = new PlateHorizontalGraph(this);
        int w = bi.getWidth();
        int h = bi.getHeight();
        for (int x = 0; x < w; ++x) {
            float counter = 0.0f;
            for (int y = 0; y < h; ++y) {
                counter += Plate.getBrightness(bi, x, y);
            }
            graph.addPeak(counter);
        }
        return graph;
    }

    @Override
    public void verticalEdgeDetector(BufferedImage source) {
        float[] matrix = new float[]{-1.0f, 0.0f, 1.0f};
        BufferedImage destination = Plate.duplicateBufferedImage(source);
        new ConvolveOp(new Kernel(3, 1, matrix), 1, null).filter(destination, source);
    }

    public void horizontalEdgeDetector(BufferedImage source) {
        BufferedImage destination = Plate.duplicateBufferedImage(source);
        float[] matrix = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
        new ConvolveOp(new Kernel(3, 3, matrix), 1, null).filter(destination, source);
    }

    public float getCharsWidthDispersion(Vector<Char> chars) {
        float averageDispersion = 0.0f;
        float averageWidth = this.getAverageCharWidth(chars);
        for (Char chr : chars) {
            averageDispersion += Math.abs(averageWidth - (float)chr.fullWidth);
        }
        return (averageDispersion /= (float)chars.size()) / averageWidth;
    }

    public float getPiecesWidthDispersion(Vector<Char> chars) {
        float averageDispersion = 0.0f;
        float averageWidth = this.getAveragePieceWidth(chars);
        for (Char chr : chars) {
            averageDispersion += Math.abs(averageWidth - (float)chr.pieceWidth);
        }
        return (averageDispersion /= (float)chars.size()) / averageWidth;
    }

    public float getAverageCharWidth(Vector<Char> chars) {
        float averageWidth = 0.0f;
        for (Char chr : chars) {
            averageWidth += (float)chr.fullWidth;
        }
        return averageWidth /= (float)chars.size();
    }

    public float getAveragePieceWidth(Vector<Char> chars) {
        float averageWidth = 0.0f;
        for (Char chr : chars) {
            averageWidth += (float)chr.pieceWidth;
        }
        return averageWidth /= (float)chars.size();
    }

    public float getAveragePieceHue(Vector<Char> chars) throws Exception {
        float averageHue = 0.0f;
        for (Char chr : chars) {
            averageHue += chr.statisticAverageHue;
        }
        return averageHue /= (float)chars.size();
    }

    public float getAveragePieceContrast(Vector<Char> chars) throws Exception {
        float averageContrast = 0.0f;
        for (Char chr : chars) {
            averageContrast += chr.statisticContrast;
        }
        return averageContrast /= (float)chars.size();
    }

    public float getAveragePieceBrightness(Vector<Char> chars) throws Exception {
        float averageBrightness = 0.0f;
        for (Char chr : chars) {
            averageBrightness += chr.statisticAverageBrightness;
        }
        return averageBrightness /= (float)chars.size();
    }

    public float getAveragePieceMinBrightness(Vector<Char> chars) throws Exception {
        float averageMinBrightness = 0.0f;
        for (Char chr : chars) {
            averageMinBrightness += chr.statisticMinimumBrightness;
        }
        return averageMinBrightness /= (float)chars.size();
    }

    public float getAveragePieceMaxBrightness(Vector<Char> chars) throws Exception {
        float averageMaxBrightness = 0.0f;
        for (Char chr : chars) {
            averageMaxBrightness += chr.statisticMaximumBrightness;
        }
        return averageMaxBrightness /= (float)chars.size();
    }

    public float getAveragePieceSaturation(Vector<Char> chars) throws Exception {
        float averageSaturation = 0.0f;
        for (Char chr : chars) {
            averageSaturation += chr.statisticAverageSaturation;
        }
        return averageSaturation /= (float)chars.size();
    }

    public float getAverageCharHeight(Vector<Char> chars) {
        float averageHeight = 0.0f;
        for (Char chr : chars) {
            averageHeight += (float)chr.fullHeight;
        }
        return averageHeight /= (float)chars.size();
    }

    public float getAveragePieceHeight(Vector<Char> chars) {
        float averageHeight = 0.0f;
        for (Char chr : chars) {
            averageHeight += (float)chr.pieceHeight;
        }
        return averageHeight /= (float)chars.size();
    }
}

