/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.RenderedImage;
import java.awt.image.ShortLookupTable;
import java.io.File;
import java.io.IOException;
import javaanpr.imageanalysis.HoughTransformation;
import javaanpr.imageanalysis.Statistics;
import javaanpr.intelligence.Intelligence;
import javax.imageio.ImageIO;

public class Photo {
    public BufferedImage image;

    public Photo() {
        this.image = null;
    }

    public Photo(BufferedImage bi) {
        this.image = bi;
    }

    public Photo(String filepath) throws IOException {
        this.loadImage(filepath);
    }

    public Photo clone() {
        return new Photo(Photo.duplicateBufferedImage(this.image));
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public int getSquare() {
        return this.getWidth() * this.getHeight();
    }

    public BufferedImage getBi() {
        return this.image;
    }

    public BufferedImage getBiWithAxes() {
        BufferedImage axis = new BufferedImage(this.image.getWidth() + 40, this.image.getHeight() + 40, 1);
        Graphics2D graphicAxis = axis.createGraphics();
        graphicAxis.setColor(Color.LIGHT_GRAY);
        Rectangle backRect = new Rectangle(0, 0, this.image.getWidth() + 40, this.image.getHeight() + 40);
        graphicAxis.fill(backRect);
        graphicAxis.draw(backRect);
        graphicAxis.drawImage((Image)this.image, 35, 5, null);
        graphicAxis.setColor(Color.BLACK);
        graphicAxis.drawRect(35, 5, this.image.getWidth(), this.image.getHeight());
        for (int ax = 0; ax < this.image.getWidth(); ax += 50) {
            graphicAxis.drawString(new Integer(ax).toString(), ax + 35, axis.getHeight() - 10);
            graphicAxis.drawLine(ax + 35, this.image.getHeight() + 5, ax + 35, this.image.getHeight() + 15);
        }
        for (int ay = 0; ay < this.image.getHeight(); ay += 50) {
            graphicAxis.drawString(new Integer(ay).toString(), 3, ay + 15);
            graphicAxis.drawLine(25, ay + 5, 35, ay + 5);
        }
        graphicAxis.dispose();
        return axis;
    }

    public void setBrightness(int x, int y, float value) {
        this.image.setRGB(x, y, new Color(value, value, value).getRGB());
    }

    public static void setBrightness(BufferedImage image, int x, int y, float value) {
        image.setRGB(x, y, new Color(value, value, value).getRGB());
    }

    public static float getBrightness(BufferedImage image, int x, int y) {
        int r = image.getRaster().getSample(x, y, 0);
        int g = image.getRaster().getSample(x, y, 1);
        int b = image.getRaster().getSample(x, y, 2);
        float[] hsb = Color.RGBtoHSB(r, g, b, null);
        return hsb[2];
    }

    public static float getSaturation(BufferedImage image, int x, int y) {
        int r = image.getRaster().getSample(x, y, 0);
        int g = image.getRaster().getSample(x, y, 1);
        int b = image.getRaster().getSample(x, y, 2);
        float[] hsb = Color.RGBtoHSB(r, g, b, null);
        return hsb[1];
    }

    public static float getHue(BufferedImage image, int x, int y) {
        int r = image.getRaster().getSample(x, y, 0);
        int g = image.getRaster().getSample(x, y, 1);
        int b = image.getRaster().getSample(x, y, 2);
        float[] hsb = Color.RGBtoHSB(r, g, b, null);
        return hsb[0];
    }

    public float getBrightness(int x, int y) {
        return Photo.getBrightness(this.image, x, y);
    }

    public float getSaturation(int x, int y) {
        return Photo.getSaturation(this.image, x, y);
    }

    public float getHue(int x, int y) {
        return Photo.getHue(this.image, x, y);
    }

    public void loadImage(String filepath) throws IOException {
        try {
            File source = new File(filepath);
            BufferedImage image = ImageIO.read(source);
            BufferedImage outimage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            Graphics2D g = outimage.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            this.image = outimage;
        }
        catch (IOException ex) {
            throw new IOException("{Error in image loader} Couldn't read input file " + filepath);
        }
    }

    public void saveImage(String filepath) throws IOException {
        String type = new String(filepath.substring(filepath.lastIndexOf(46) + 1, filepath.length()).toUpperCase());
        if (!(type.equals("BMP") || type.equals("JPG") || type.equals("JPEG") || type.equals("PNG"))) {
            throw new IOException("Unsupported file format");
        }
        File destination = new File(filepath);
        ImageIO.write((RenderedImage)this.image, type, destination);
    }

    public void normalizeBrightness(float coef) {
        Statistics stats = new Statistics(this);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                Photo.setBrightness(this.image, x, y, stats.thresholdBrightness(Photo.getBrightness(this.image, x, y), coef));
            }
        }
    }

    public void linearResize(int width, int height) {
        this.image = Photo.linearResizeBi(this.image, width, height);
    }

    public static BufferedImage linearResizeBi(BufferedImage origin, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 1);
        Graphics2D g = resizedImage.createGraphics();
        float xScale = (float)width / (float)origin.getWidth();
        float yScale = (float)height / (float)origin.getHeight();
        AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
        g.drawRenderedImage(origin, at);
        g.dispose();
        return resizedImage;
    }

    public void averageResize(int width, int height) {
        this.image = this.averageResizeBi(this.image, width, height);
    }

    public BufferedImage averageResizeBi(BufferedImage origin, int width, int height) {
        if (origin.getWidth() < width || origin.getHeight() < height) {
            return Photo.linearResizeBi(origin, width, height);
        }
        BufferedImage resized = new BufferedImage(width, height, 1);
        float xScale = (float)origin.getWidth() / (float)width;
        float yScale = (float)origin.getHeight() / (float)height;
        for (int x = 0; x < width; ++x) {
            int x0min = Math.round((float)x * xScale);
            int x0max = Math.round((float)(x + 1) * xScale);
            for (int y = 0; y < height; ++y) {
                int y0min = Math.round((float)y * yScale);
                int y0max = Math.round((float)(y + 1) * yScale);
                float sum = 0.0f;
                int sumCount = 0;
                for (int x0 = x0min; x0 < x0max; ++x0) {
                    for (int y0 = y0min; y0 < y0max; ++y0) {
                        sum += Photo.getBrightness(origin, x0, y0);
                        ++sumCount;
                    }
                }
                Photo.setBrightness(resized, x, y, sum /= (float)sumCount);
            }
        }
        return resized;
    }

    public Photo duplicate() {
        return new Photo(Photo.duplicateBufferedImage(this.image));
    }

    public static BufferedImage duplicateBufferedImage(BufferedImage image) {
        BufferedImage imageCopy = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        imageCopy.setData(image.getData());
        return imageCopy;
    }

    static void thresholding(BufferedImage bi) {
        int i;
        short[] threshold = new short[256];
        for (i = 0; i < 36; i = (int)((short)(i + 1))) {
            threshold[i] = 0;
        }
        for (i = 36; i < 256; i = (int)((short)(i + 1))) {
            threshold[i] = i;
        }
        LookupOp thresholdOp = new LookupOp(new ShortLookupTable(0, threshold), null);
        thresholdOp.filter(bi, bi);
    }

    public void verticalEdgeDetector(BufferedImage source) {
        BufferedImage destination = Photo.duplicateBufferedImage(source);
        float[] data1 = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
        float[] data2 = new float[]{1.0f, 0.0f, -1.0f, 2.0f, 0.0f, -2.0f, 1.0f, 0.0f, -1.0f};
        new ConvolveOp(new Kernel(3, 3, data1), 1, null).filter(destination, source);
    }

    public float[][] bufferedImageToArray(BufferedImage image, int w, int h) {
        float[][] array = new float[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                array[x][y] = Photo.getBrightness(image, x, y);
            }
        }
        return array;
    }

    public float[][] bufferedImageToArrayWithBounds(BufferedImage image, int w, int h) {
        int x;
        float[][] array = new float[w + 2][h + 2];
        for (x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                array[x + 1][y + 1] = Photo.getBrightness(image, x, y);
            }
        }
        for (x = 0; x < w + 2; ++x) {
            array[x][0] = 1.0f;
            array[x][h + 1] = 1.0f;
        }
        for (int y = 0; y < h + 2; ++y) {
            array[0][y] = 1.0f;
            array[w + 1][y] = 1.0f;
        }
        return array;
    }

    public static BufferedImage arrayToBufferedImage(float[][] array, int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 1);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                Photo.setBrightness(bi, x, y, array[x][y]);
            }
        }
        return bi;
    }

    public static BufferedImage createBlankBi(BufferedImage image) {
        BufferedImage imageCopy = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        return imageCopy;
    }

    public BufferedImage createBlankBi(int width, int height) {
        BufferedImage imageCopy = new BufferedImage(width, height, 1);
        return imageCopy;
    }

    public BufferedImage sumBi(BufferedImage bi1, BufferedImage bi2) {
        BufferedImage out = new BufferedImage(Math.min(bi1.getWidth(), bi2.getWidth()), Math.min(bi1.getHeight(), bi2.getHeight()), 1);
        for (int x = 0; x < out.getWidth(); ++x) {
            for (int y = 0; y < out.getHeight(); ++y) {
                Photo.setBrightness(out, x, y, (float)Math.min(1.0, (double)(Photo.getBrightness(bi1, x, y) + Photo.getBrightness(bi2, x, y))));
            }
        }
        return out;
    }

    public void plainThresholding(Statistics stat) {
        int w = this.getWidth();
        int h = this.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                this.setBrightness(x, y, stat.thresholdBrightness(this.getBrightness(x, y), 1.0f));
            }
        }
    }

    public void adaptiveThresholding() {
        Statistics stat = new Statistics(this);
        int radius = Intelligence.configurator.getIntProperty("photo_adaptivethresholdingradius");
        if (radius == 0) {
            this.plainThresholding(stat);
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        float[][] sourceArray = this.bufferedImageToArray(this.image, w, h);
        float[][] destinationArray = this.bufferedImageToArray(this.image, w, h);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int count = 0;
                float neighborhood = 0.0f;
                for (int ix = x - radius; ix <= x + radius; ++ix) {
                    for (int iy = y - radius; iy <= y + radius; ++iy) {
                        if (ix < 0 || iy < 0 || ix >= w || iy >= h) continue;
                        neighborhood += sourceArray[ix][iy];
                        ++count;
                    }
                }
                destinationArray[x][y] = destinationArray[x][y] < (neighborhood /= (float)count) ? 0.0f : 1.0f;
            }
        }
        this.image = Photo.arrayToBufferedImage(destinationArray, w, h);
    }

    public HoughTransformation getHoughTransformation() {
        HoughTransformation hough = new HoughTransformation(this.getWidth(), this.getHeight());
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                hough.addLine(x, y, this.getBrightness(x, y));
            }
        }
        return hough;
    }
}

