/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph {
    public Vector<Peak> peaks = null;
    public Vector<Float> yValues = new Vector();
    private boolean actualAverageValue = false;
    private boolean actualMaximumValue = false;
    private boolean actualMinimumValue = false;
    private float averageValue;
    private float maximumValue;
    private float minimumValue;

    void deActualizeFlags() {
        this.actualAverageValue = false;
        this.actualMaximumValue = false;
        this.actualMinimumValue = false;
    }

    boolean allowedInterval(Vector<Peak> peaks, int xPosition) {
        for (Peak peak : peaks) {
            if (peak.left > xPosition || xPosition > peak.right) continue;
            return false;
        }
        return true;
    }

    public void addPeak(float value) {
        this.yValues.add(Float.valueOf(value));
        this.deActualizeFlags();
    }

    public void applyProbabilityDistributor(ProbabilityDistributor probability) {
        this.yValues = probability.distribute(this.yValues);
        this.deActualizeFlags();
    }

    public void negate() {
        float max = this.getMaxValue();
        for (int i = 0; i < this.yValues.size(); ++i) {
            this.yValues.setElementAt(Float.valueOf(max - this.yValues.elementAt(i).floatValue()), i);
        }
        this.deActualizeFlags();
    }

    float getAverageValue() {
        if (!this.actualAverageValue) {
            this.averageValue = this.getAverageValue(0, this.yValues.size());
            this.actualAverageValue = true;
        }
        return this.averageValue;
    }

    float getAverageValue(int a, int b) {
        float sum = 0.0f;
        for (int i = a; i < b; ++i) {
            sum = (float)((double)sum + this.yValues.elementAt(i).doubleValue());
        }
        return sum / (float)this.yValues.size();
    }

    float getMaxValue() {
        if (!this.actualMaximumValue) {
            this.maximumValue = this.getMaxValue(0, this.yValues.size());
            this.actualMaximumValue = true;
        }
        return this.maximumValue;
    }

    float getMaxValue(int a, int b) {
        float maxValue = 0.0f;
        for (int i = a; i < b; ++i) {
            maxValue = Math.max(maxValue, this.yValues.elementAt(i).floatValue());
        }
        return maxValue;
    }

    float getMaxValue(float a, float b) {
        int ia = (int)(a * (float)this.yValues.size());
        int ib = (int)(b * (float)this.yValues.size());
        return this.getMaxValue(ia, ib);
    }

    int getMaxValueIndex(int a, int b) {
        float maxValue = 0.0f;
        int maxIndex = a;
        for (int i = a; i < b; ++i) {
            if (!(this.yValues.elementAt(i).floatValue() >= maxValue)) continue;
            maxValue = this.yValues.elementAt(i).floatValue();
            maxIndex = i;
        }
        return maxIndex;
    }

    float getMinValue() {
        if (!this.actualMinimumValue) {
            this.minimumValue = this.getMinValue(0, this.yValues.size());
            this.actualMinimumValue = true;
        }
        return this.minimumValue;
    }

    float getMinValue(int a, int b) {
        float minValue = Float.POSITIVE_INFINITY;
        for (int i = a; i < b; ++i) {
            minValue = Math.min(minValue, this.yValues.elementAt(i).floatValue());
        }
        return minValue;
    }

    float getMinValue(float a, float b) {
        int ia = (int)(a * (float)this.yValues.size());
        int ib = (int)(b * (float)this.yValues.size());
        return this.getMinValue(ia, ib);
    }

    int getMinValueIndex(int a, int b) {
        float minValue = Float.POSITIVE_INFINITY;
        int minIndex = b;
        for (int i = a; i < b; ++i) {
            if (!(this.yValues.elementAt(i).floatValue() <= minValue)) continue;
            minValue = this.yValues.elementAt(i).floatValue();
            minIndex = i;
        }
        return minIndex;
    }

    public BufferedImage renderHorizontally(int width, int height) {
        int i;
        BufferedImage content = new BufferedImage(width, height, 1);
        BufferedImage axis = new BufferedImage(width + 40, height + 40, 1);
        Graphics2D graphicContent = content.createGraphics();
        Graphics2D graphicAxis = axis.createGraphics();
        Rectangle backRect = new Rectangle(0, 0, width + 40, height + 40);
        graphicAxis.setColor(Color.LIGHT_GRAY);
        graphicAxis.fill(backRect);
        graphicAxis.draw(backRect);
        backRect = new Rectangle(0, 0, width, height);
        graphicContent.setColor(Color.WHITE);
        graphicContent.fill(backRect);
        graphicContent.draw(backRect);
        int x = 0;
        int y = 0;
        graphicContent.setColor(Color.GREEN);
        for (i = 0; i < this.yValues.size(); ++i) {
            int x0 = x;
            int y0 = y;
            x = (int)((float)i / (float)this.yValues.size() * (float)width);
            y = (int)((1.0f - this.yValues.elementAt(i).floatValue() / this.getMaxValue()) * (float)height);
            graphicContent.drawLine(x0, y0, x, y);
        }
        if (this.peaks != null) {
            graphicContent.setColor(Color.RED);
            i = 0;
            double multConst = (double)width / (double)this.yValues.size();
            for (Peak p : this.peaks) {
                graphicContent.drawLine((int)((double)p.left * multConst), 0, (int)((double)p.center * multConst), 30);
                graphicContent.drawLine((int)((double)p.center * multConst), 30, (int)((double)p.right * multConst), 0);
                graphicContent.drawString(i++ + ".", (int)((double)p.center * multConst) - 5, 42);
            }
        }
        graphicAxis.drawImage((Image)content, 35, 5, null);
        graphicAxis.setColor(Color.BLACK);
        graphicAxis.drawRect(35, 5, content.getWidth(), content.getHeight());
        for (int ax = 0; ax < content.getWidth(); ax += 50) {
            graphicAxis.drawString(new Integer(ax).toString(), ax + 35, axis.getHeight() - 10);
            graphicAxis.drawLine(ax + 35, content.getHeight() + 5, ax + 35, content.getHeight() + 15);
        }
        for (int ay = 0; ay < content.getHeight(); ay += 20) {
            graphicAxis.drawString(new Integer(new Float((1.0f - (float)ay / (float)content.getHeight()) * 100.0f).intValue()).toString() + "%", 1, ay + 15);
            graphicAxis.drawLine(25, ay + 5, 35, ay + 5);
        }
        graphicContent.dispose();
        graphicAxis.dispose();
        return axis;
    }

    public BufferedImage renderVertically(int width, int height) {
        int i;
        BufferedImage content = new BufferedImage(width, height, 1);
        BufferedImage axis = new BufferedImage(width + 10, height + 40, 1);
        Graphics2D graphicContent = content.createGraphics();
        Graphics2D graphicAxis = axis.createGraphics();
        Rectangle backRect = new Rectangle(0, 0, width + 40, height + 40);
        graphicAxis.setColor(Color.LIGHT_GRAY);
        graphicAxis.fill(backRect);
        graphicAxis.draw(backRect);
        backRect = new Rectangle(0, 0, width, height);
        graphicContent.setColor(Color.WHITE);
        graphicContent.fill(backRect);
        graphicContent.draw(backRect);
        int x = width;
        int y = 0;
        graphicContent.setColor(Color.GREEN);
        for (i = 0; i < this.yValues.size(); ++i) {
            int x0 = x;
            int y0 = y;
            y = (int)((float)i / (float)this.yValues.size() * (float)height);
            x = (int)(this.yValues.elementAt(i).floatValue() / this.getMaxValue() * (float)width);
            graphicContent.drawLine(x0, y0, x, y);
        }
        if (this.peaks != null) {
            graphicContent.setColor(Color.RED);
            i = 0;
            double multConst = (double)height / (double)this.yValues.size();
            for (Peak p : this.peaks) {
                graphicContent.drawLine(width, (int)((double)p.left * multConst), width - 30, (int)((double)p.center * multConst));
                graphicContent.drawLine(width - 30, (int)((double)p.center * multConst), width, (int)((double)p.right * multConst));
                graphicContent.drawString(i++ + ".", width - 38, (int)((double)p.center * multConst) + 5);
            }
        }
        graphicAxis.drawImage((Image)content, 5, 5, null);
        graphicAxis.setColor(Color.BLACK);
        graphicAxis.drawRect(5, 5, content.getWidth(), content.getHeight());
        graphicContent.dispose();
        graphicAxis.dispose();
        return axis;
    }

    public void rankFilter(int size) {
        int halfSize = size / 2;
        Vector<Float> clone = new Vector<Float>(this.yValues);
        for (int i = halfSize; i < this.yValues.size() - halfSize; ++i) {
            float sum = 0.0f;
            for (int ii = i - halfSize; ii < i + halfSize; ++ii) {
                sum += clone.elementAt(ii).floatValue();
            }
            this.yValues.setElementAt(Float.valueOf(sum / (float)size), i);
        }
    }

    public int indexOfLeftPeakRel(int peak, double peakFootConstantRel) {
        int index = peak;
        int i = peak;
        while (i >= 0 && !((double)this.yValues.elementAt(index = i--).floatValue() < peakFootConstantRel * (double)this.yValues.elementAt(peak).floatValue())) {
        }
        return Math.max(0, index);
    }

    public int indexOfRightPeakRel(int peak, double peakFootConstantRel) {
        int index = peak;
        int i = peak;
        while (i < this.yValues.size() && !((double)this.yValues.elementAt(index = i++).floatValue() < peakFootConstantRel * (double)this.yValues.elementAt(peak).floatValue())) {
        }
        return Math.min(this.yValues.size(), index);
    }

    public float averagePeakDiff(Vector<Peak> peaks) {
        float sum = 0.0f;
        for (Peak p : peaks) {
            sum += (float)p.getDiff();
        }
        return sum / (float)peaks.size();
    }

    public float maximumPeakDiff(Vector<Peak> peaks, int from, int to) {
        float max = 0.0f;
        for (int i = from; i <= to; ++i) {
            max = Math.max(max, (float)peaks.elementAt(i).getDiff());
        }
        return max;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProbabilityDistributor {
        float center;
        float power;
        int leftMargin;
        int rightMargin;

        public ProbabilityDistributor(float center, float power, int leftMargin, int rightMargin) {
            this.center = center;
            this.power = power;
            this.leftMargin = Math.max(1, leftMargin);
            this.rightMargin = Math.max(1, rightMargin);
        }

        private float distributionFunction(float value, float positionPercentage) {
            return value * (1.0f - this.power * Math.abs(positionPercentage - this.center));
        }

        public Vector<Float> distribute(Vector<Float> peaks) {
            Vector<Float> distributedPeaks = new Vector<Float>();
            for (int i = 0; i < peaks.size(); ++i) {
                if (i < this.leftMargin || i > peaks.size() - this.rightMargin) {
                    distributedPeaks.add(Float.valueOf(0.0f));
                    continue;
                }
                distributedPeaks.add(Float.valueOf(this.distributionFunction(peaks.elementAt(i).floatValue(), (float)i / (float)peaks.size())));
            }
            return distributedPeaks;
        }
    }

    public class Peak {
        public int left;
        public int center;
        public int right;

        public Peak(int left, int center, int right) {
            this.left = left;
            this.center = center;
            this.right = right;
        }

        public Peak(int left, int right) {
            this.left = left;
            this.center = (left + right) / 2;
            this.right = right;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public int getCenter() {
            return this.center;
        }

        public int getDiff() {
            return this.right - this.left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public void setCenter(int center) {
            this.center = center;
        }

        public void setRight(int right) {
            this.right = right;
        }
    }
}

