/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.IOException;
import java.util.Vector;
import javaanpr.imageanalysis.Band;
import javaanpr.imageanalysis.CarSnapshotGraph;
import javaanpr.imageanalysis.Graph;
import javaanpr.imageanalysis.Photo;
import javaanpr.intelligence.Intelligence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarSnapshot
extends Photo {
    private static int distributor_margins = Intelligence.configurator.getIntProperty("carsnapshot_distributormargins");
    private static int carsnapshot_graphrankfilter = Intelligence.configurator.getIntProperty("carsnapshot_graphrankfilter");
    private static int numberOfCandidates = Intelligence.configurator.getIntProperty("intelligence_numberOfBands");
    private CarSnapshotGraph graphHandle = null;
    public static Graph.ProbabilityDistributor distributor = new Graph.ProbabilityDistributor(0.0f, 0.0f, distributor_margins, distributor_margins);

    public CarSnapshot() {
    }

    public CarSnapshot(String filepath) throws IOException {
        super(filepath);
    }

    public CarSnapshot(BufferedImage bi) {
        super(bi);
    }

    public BufferedImage renderGraph() {
        this.computeGraph();
        return this.graphHandle.renderVertically(100, this.getHeight());
    }

    private Vector<Graph.Peak> computeGraph() {
        if (this.graphHandle != null) {
            return this.graphHandle.peaks;
        }
        BufferedImage imageCopy = CarSnapshot.duplicateBufferedImage(this.image);
        this.verticalEdgeBi(imageCopy);
        CarSnapshot.thresholding(imageCopy);
        this.graphHandle = this.histogram(imageCopy);
        this.graphHandle.rankFilter(carsnapshot_graphrankfilter);
        this.graphHandle.applyProbabilityDistributor(distributor);
        this.graphHandle.findPeaks(numberOfCandidates);
        return this.graphHandle.peaks;
    }

    public Vector<Band> getBands() {
        Vector<Band> out = new Vector<Band>();
        Vector<Graph.Peak> peaks = this.computeGraph();
        for (int i = 0; i < peaks.size(); ++i) {
            Graph.Peak p = peaks.elementAt(i);
            out.add(new Band(this.image.getSubimage(0, p.getLeft(), this.image.getWidth(), p.getDiff())));
        }
        return out;
    }

    public void verticalEdgeBi(BufferedImage image) {
        BufferedImage imageCopy = CarSnapshot.duplicateBufferedImage(image);
        float[] data = new float[]{-1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f};
        new ConvolveOp(new Kernel(3, 4, data), 1, null).filter(imageCopy, image);
    }

    public CarSnapshotGraph histogram(BufferedImage bi) {
        CarSnapshotGraph graph = new CarSnapshotGraph(this);
        for (int y = 0; y < bi.getHeight(); ++y) {
            float counter = 0.0f;
            for (int x = 0; x < bi.getWidth(); ++x) {
                counter += CarSnapshot.getBrightness(bi, x, y);
            }
            graph.addPeak(counter);
        }
        return graph;
    }
}

