/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Vector;
import javaanpr.imageanalysis.BandGraph;
import javaanpr.imageanalysis.Graph;
import javaanpr.imageanalysis.Photo;
import javaanpr.imageanalysis.Plate;
import javaanpr.intelligence.Intelligence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Band
extends Photo {
    public static Graph.ProbabilityDistributor distributor = new Graph.ProbabilityDistributor(0.0f, 0.0f, 25, 25);
    private static int numberOfCandidates = Intelligence.configurator.getIntProperty("intelligence_numberOfPlates");
    private BandGraph graphHandle = null;

    public Band() {
        this.image = null;
    }

    public Band(BufferedImage bi) {
        super(bi);
    }

    public BufferedImage renderGraph() {
        this.computeGraph();
        return this.graphHandle.renderHorizontally(this.getWidth(), 100);
    }

    private Vector<Graph.Peak> computeGraph() {
        if (this.graphHandle != null) {
            return this.graphHandle.peaks;
        }
        BufferedImage imageCopy = Band.duplicateBufferedImage(this.image);
        this.fullEdgeDetector(imageCopy);
        this.graphHandle = this.histogram(imageCopy);
        this.graphHandle.rankFilter(this.image.getHeight());
        this.graphHandle.applyProbabilityDistributor(distributor);
        this.graphHandle.findPeaks(numberOfCandidates);
        return this.graphHandle.peaks;
    }

    public Vector<Plate> getPlates() {
        Vector<Plate> out = new Vector<Plate>();
        Vector<Graph.Peak> peaks = this.computeGraph();
        for (int i = 0; i < peaks.size(); ++i) {
            Graph.Peak p = peaks.elementAt(i);
            out.add(new Plate(this.image.getSubimage(p.getLeft(), 0, p.getDiff(), this.image.getHeight())));
        }
        return out;
    }

    public BandGraph histogram(BufferedImage bi) {
        BandGraph graph = new BandGraph(this);
        for (int x = 0; x < bi.getWidth(); ++x) {
            float counter = 0.0f;
            for (int y = 0; y < bi.getHeight(); ++y) {
                counter += Band.getBrightness(bi, x, y);
            }
            graph.addPeak(counter);
        }
        return graph;
    }

    public void fullEdgeDetector(BufferedImage source) {
        float[] verticalMatrix = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
        float[] horizontalMatrix = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
        BufferedImage i1 = Band.createBlankBi(source);
        BufferedImage i2 = Band.createBlankBi(source);
        new ConvolveOp(new Kernel(3, 3, verticalMatrix), 1, null).filter(source, i1);
        new ConvolveOp(new Kernel(3, 3, horizontalMatrix), 1, null).filter(source, i2);
        int w = source.getWidth();
        int h = source.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                float sum = 0.0f;
                sum += Band.getBrightness(i1, x, y);
                Band.setBrightness(source, x, y, Math.min(1.0f, sum += Band.getBrightness(i2, x, y)));
            }
        }
    }
}

