/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.gui;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import javaanpr.intelligence.Intelligence;
import javax.imageio.ImageIO;

public class ReportGenerator {
    private String path;
    private String output;
    private BufferedWriter out;
    private boolean enabled;

    public ReportGenerator(String path) throws IOException {
        this.path = path;
        this.enabled = true;
        File f = new File(path);
        if (!f.exists()) {
            throw new IOException("Report directory '" + path + "' doesn't exists");
        }
        this.output = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><html><head><title>ANPR report</title></head><style type=\"text/css\">@import \"style.css\";</style>";
    }

    public ReportGenerator() {
        this.enabled = false;
    }

    public void insertText(String text) {
        if (!this.enabled) {
            return;
        }
        this.output = this.output + text;
        this.output = this.output + "\n";
    }

    public void insertImage(BufferedImage image, String cls, int w, int h) throws IOException {
        if (!this.enabled) {
            return;
        }
        String imageName = String.valueOf(image.hashCode()) + ".jpg";
        this.saveImage(image, this.path + File.separator + imageName);
        this.output = w != 0 && h != 0 ? this.output + "<img src='" + imageName + "' alt='' width='" + w + "' height='" + h + "' class='" + cls + "'>\n" : this.output + "<img src='" + imageName + "' alt='' class='" + cls + "'>\n";
    }

    public void finish() throws Exception {
        if (!this.enabled) {
            return;
        }
        this.output = this.output + "</html>";
        FileOutputStream os = new FileOutputStream(this.path + File.separator + "index.html");
        OutputStreamWriter writer = new OutputStreamWriter(os);
        writer.write(this.output);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        this.copyFile(new File(Intelligence.configurator.getPathProperty("reportgeneratorcss")), new File(this.path + File.separator + "style.css"));
    }

    public void copyFile(File in, File out) throws Exception {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    public void saveImage(BufferedImage bi, String filepath) throws IOException {
        if (!this.enabled) {
            return;
        }
        String type = new String(filepath.substring(filepath.lastIndexOf(46) + 1, filepath.length()).toUpperCase());
        if (!(type.equals("BMP") || type.equals("JPG") || type.equals("JPEG") || type.equals("PNG"))) {
            System.out.println("unsupported format exception");
        }
        File destination = new File(filepath);
        try {
            ImageIO.write((RenderedImage)bi, type, destination);
        }
        catch (Exception e) {
            System.out.println("catched " + e.toString());
            System.exit(1);
            throw new IOException("Can't open destination report directory");
        }
    }
}

