/*
 * Decompiled with CFR 0.152.
 */
package javaanpr;

import java.io.File;
import java.io.IOException;
import javaanpr.configurator.Configurator;
import javaanpr.gui.ReportGenerator;
import javaanpr.gui.windows.FrameComponentInit;
import javaanpr.gui.windows.FrameMain;
import javaanpr.imageanalysis.CarSnapshot;
import javaanpr.imageanalysis.Char;
import javaanpr.intelligence.Intelligence;
import javaanpr.recognizer.NeuralPatternClassificator;
import javax.swing.UIManager;

public class Main {
    public static ReportGenerator rg = new ReportGenerator();
    public static Intelligence systemLogic;
    public static String helpText;

    public static void newAlphabet(String srcdir, String dstdir) throws Exception {
        File folder = new File(srcdir);
        if (!folder.exists()) {
            throw new IOException("Source folder doesn't exists");
        }
        if (!new File(dstdir).exists()) {
            throw new IOException("Destination folder doesn't exists");
        }
        int x = Intelligence.configurator.getIntProperty("char_normalizeddimensions_x");
        int y = Intelligence.configurator.getIntProperty("char_normalizeddimensions_y");
        System.out.println("\nCreating new alphabet (" + x + " x " + y + " px)... \n");
        for (String fileName : folder.list()) {
            Char c = new Char(srcdir + File.separator + fileName);
            c.normalize();
            c.saveImage(dstdir + File.separator + fileName);
            System.out.println(fileName + " done");
        }
    }

    public static void learnAlphabet(String destinationFile) throws Exception {
        try {
            File f = new File(destinationFile);
            f.createNewFile();
        }
        catch (Exception e) {
            throw new IOException("Can't find the path specified");
        }
        System.out.println();
        NeuralPatternClassificator npc = new NeuralPatternClassificator(true);
        npc.network.saveToXml(destinationFile);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length == 1 && args[0].equals("-gui")) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            FrameComponentInit frameComponentInit = new FrameComponentInit();
            systemLogic = new Intelligence(false);
            frameComponentInit.dispose();
            FrameMain mainFrame = new FrameMain();
        } else if (args.length == 3 && args[0].equals("-recognize") && args[1].equals("-i")) {
            try {
                systemLogic = new Intelligence(false);
                System.out.println(systemLogic.recognize(new CarSnapshot(args[2])));
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        } else if (args.length == 5 && args[0].equals("-recognize") && args[1].equals("-i") && args[3].equals("-o")) {
            try {
                rg = new ReportGenerator(args[4]);
                systemLogic = new Intelligence(true);
                systemLogic.recognize(new CarSnapshot(args[2]));
                rg.finish();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        } else if (args.length == 3 && args[0].equals("-newconfig") && args[1].equals("-o")) {
            Configurator configurator = new Configurator();
            try {
                configurator.saveConfiguration(args[2]);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        } else if (args.length == 3 && args[0].equals("-newnetwork") && args[1].equals("-o")) {
            try {
                Main.learnAlphabet(args[2]);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else if (args.length == 5 && args[0].equals("-newalphabet") && args[1].equals("-i") && args[3].equals("-o")) {
            try {
                Main.newAlphabet(args[2], args[4]);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else {
            System.out.println(helpText);
        }
    }

    static {
        helpText = "-----------------------------------------------------------\nAutomatic number plate recognition system\nCopyright (c) Ondrej Martinsky, 2006-2007\n\nLicensed under the Educational Community License,\n\nUsage : java -jar anpr.jar [-options]\n\nWhere options include:\n\n    -help         Displays this help\n    -gui          Run GUI viewer (default choice)\n    -recognize -i <snapshot>\n                  Recognize single snapshot\n    -recognize -i <snapshot> -o <dstdir>\n                  Recognize single snapshot and\n                  save report html into specified\n                  directory\n    -newconfig -o <file>\n                  Generate default configuration file\n    -newnetwork -o <file>\n                  Train neural network according to\n                  specified feature extraction method and\n                  learning parameters (in config. file)\n                  and saves it into output file\n    -newalphabet -i <srcdir> -o <dstdir>\n                  Normalize all images in <srcdir> and save\n                  it to <dstdir>.";
    }
}

