/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

////////////////////////////////////////////////////////////////////
//
//  file: dsm.c: base fukction of disassembler like help printig etc.
//  		     and calling main parsing function
//
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <exception>
#include "dsmparser.h"
#include "usedattr.h"
#include "dsmknittingalg.h"
#include "dsml.h"
#include "dsmscanl.h"
#include "exceptions.h"
#include "opschedull.h"
#include "swtiol.h"

using namespace std;

int main(int argc, char **argv)
{
	char *g_ifilename = NULL;
	char *g_ofilename = NULL;
	
	try
    {
		// get program arguments
		swtiol_argpars_P2(argc, argv, &g_ifilename, &g_ofilename);
			
		if (g_ofilename == NULL)
		{
			g_ofilename = "stdout";
		}
				
		// init the scanner library
		dsmscanl_init(g_ifilename,g_ofilename);
		
        // initialisation of the operations' scheduler - the argument is the assembler scanner        
        opschedull_init(&dsmscanl_dsmyylex);		
		
		// init the disasml library		
		dsml_init_knittingalg(YYNT_FIRST, YYNT_LAST);
				
		yyparse();
	
		// deinit the kniting algorithm
		dsml_deinit_knittingalg();
		
        // deinitialisation of the operations' scheduler
        opschedull_deinit();
		
		// deinit the scaner library
		dsmscanl_deinit();
	}catch (exception & e)
    {
		// add error prefix before error message alone 
    	string tmp = "Error: ";
    	tmp+=e.what();
        cout << tmp.c_str() << endl;
    }
	return 0;
}
